/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.ThresholdSecurities;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class ThresholdSecuritiesTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        LocalDate tradeDate = (LocalDate)this.fixture.create(LocalDate.class);
        String symbolInINETSymbology = (String)this.fixture.create(String.class);
        String symbolInCQSSymbology = (String)this.fixture.create(String.class);
        String symbolInCMSSymbology = (String)this.fixture.create(String.class);
        String cusip = (String)this.fixture.create(String.class);
        String securityName = (String)this.fixture.create(String.class);
        ThresholdSecurities thresholdSecurities = new ThresholdSecurities(tradeDate, symbolInINETSymbology, symbolInCQSSymbology, symbolInCMSSymbology, cusip, securityName);
        Assertions.assertThat((LocalDate)thresholdSecurities.getTradeDate()).isEqualTo((Object)tradeDate);
        Assertions.assertThat((String)thresholdSecurities.getSymbolInINETSymbology()).isEqualTo((Object)symbolInINETSymbology);
        Assertions.assertThat((String)thresholdSecurities.getSymbolInCQSSymbology()).isEqualTo((Object)symbolInCQSSymbology);
        Assertions.assertThat((String)thresholdSecurities.getSymbolInCMSSymbology()).isEqualTo((Object)symbolInCMSSymbology);
        Assertions.assertThat((String)thresholdSecurities.getCusip()).isEqualTo((Object)cusip);
        Assertions.assertThat((String)thresholdSecurities.getSecurityName()).isEqualTo((Object)securityName);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(ThresholdSecurities.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(ThresholdSecurities.class)).verify();
    }
}

