/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.alternative;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalTime;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.alternative.Sentiment;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class SentimentTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal sentiment = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal totalScores = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal positive = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal negative = (BigDecimal)this.fixture.create(BigDecimal.class);
        LocalTime minute = (LocalTime)this.fixture.create(LocalTime.class);
        Sentiment sentimentObject = new Sentiment(sentiment, totalScores, positive, negative, minute);
        Assertions.assertThat((BigDecimal)sentimentObject.getSentiment()).isEqualTo((Object)sentiment);
        Assertions.assertThat((BigDecimal)sentimentObject.getTotalScores()).isEqualTo((Object)totalScores);
        Assertions.assertThat((BigDecimal)sentimentObject.getPositive()).isEqualTo((Object)positive);
        Assertions.assertThat((BigDecimal)sentimentObject.getNegative()).isEqualTo((Object)negative);
        Assertions.assertThat((LocalTime)sentimentObject.getMinute()).isEqualTo((Object)minute);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Sentiment.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Sentiment.class)).verify();
    }
}

