/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalTime;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.marketdata.Auction;
import pl.zankowski.iextrading4j.api.marketdata.AuctionType;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class AuctionTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        AuctionType auctionType = (AuctionType)this.fixture.create(AuctionType.class);
        BigDecimal pairedShares = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal imbalanceShares = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal referencePrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal indicativePrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal auctionBookPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal collarReferencePrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal lowerCollarPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal upperCollarPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal extensionNumber = (BigDecimal)this.fixture.create(BigDecimal.class);
        LocalTime startTime = (LocalTime)this.fixture.create(LocalTime.class);
        Long lastUpdate = (Long)this.fixture.create(Long.class);
        Auction auction = new Auction(auctionType, pairedShares, imbalanceShares, referencePrice, indicativePrice, auctionBookPrice, collarReferencePrice, lowerCollarPrice, upperCollarPrice, extensionNumber, startTime, lastUpdate);
        Assertions.assertThat((Comparable)auction.getAuctionType()).isEqualTo((Object)auctionType);
        Assertions.assertThat((BigDecimal)auction.getPairedShares()).isEqualTo((Object)pairedShares);
        Assertions.assertThat((BigDecimal)auction.getImbalanceShares()).isEqualTo((Object)imbalanceShares);
        Assertions.assertThat((BigDecimal)auction.getReferencePrice()).isEqualTo((Object)referencePrice);
        Assertions.assertThat((BigDecimal)auction.getIndicativePrice()).isEqualTo((Object)indicativePrice);
        Assertions.assertThat((BigDecimal)auction.getAuctionBookPrice()).isEqualTo((Object)auctionBookPrice);
        Assertions.assertThat((BigDecimal)auction.getCollarReferencePrice()).isEqualTo((Object)collarReferencePrice);
        Assertions.assertThat((BigDecimal)auction.getLowerCollarPrice()).isEqualTo((Object)lowerCollarPrice);
        Assertions.assertThat((BigDecimal)auction.getUpperCollarPrice()).isEqualTo((Object)upperCollarPrice);
        Assertions.assertThat((BigDecimal)auction.getExtensionNumber()).isEqualTo((Object)extensionNumber);
        Assertions.assertThat((LocalTime)auction.getStartTime()).isEqualTo((Object)startTime);
        Assertions.assertThat((Long)auction.getLastUpdate()).isEqualTo((Object)lastUpdate);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Auction.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Auction.class)).verify();
    }
}

