/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.marketdata.BookEntry;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class BookEntryTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal price = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal size = (BigDecimal)this.fixture.create(BigDecimal.class);
        Long timestamp = (Long)this.fixture.create(Long.class);
        BookEntry bookEntry = new BookEntry(price, size, timestamp);
        Assertions.assertThat((BigDecimal)bookEntry.getPrice()).isEqualTo((Object)price);
        Assertions.assertThat((BigDecimal)bookEntry.getSize()).isEqualTo((Object)size);
        Assertions.assertThat((Long)bookEntry.getTimestamp()).isEqualTo((Object)timestamp);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(BookEntry.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(BookEntry.class)).verify();
    }
}

