/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.marketdata.TOPS;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class TOPSTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        String symbol = (String)this.fixture.create(String.class);
        BigDecimal marketPercent = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal bidSize = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal bidPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal askSize = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal askPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal volume = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal lastSalePrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal lastSaleSize = (BigDecimal)this.fixture.create(BigDecimal.class);
        Long lastSaleTime = (Long)this.fixture.create(Long.class);
        Long lastUpdated = (Long)this.fixture.create(Long.class);
        String sector = (String)this.fixture.create(String.class);
        String securityType = (String)this.fixture.create(String.class);
        TOPS tops = new TOPS(symbol, marketPercent, bidSize, bidPrice, askSize, askPrice, volume, lastSalePrice, lastSaleSize, lastSaleTime, lastUpdated, sector, securityType);
        Assertions.assertThat((String)tops.getSymbol()).isEqualTo((Object)symbol);
        Assertions.assertThat((BigDecimal)tops.getMarketPercent()).isEqualTo((Object)marketPercent);
        Assertions.assertThat((BigDecimal)tops.getBidSize()).isEqualTo((Object)bidSize);
        Assertions.assertThat((BigDecimal)tops.getBidPrice()).isEqualTo((Object)bidPrice);
        Assertions.assertThat((BigDecimal)tops.getAskSize()).isEqualTo((Object)askSize);
        Assertions.assertThat((BigDecimal)tops.getAskPrice()).isEqualTo((Object)askPrice);
        Assertions.assertThat((BigDecimal)tops.getVolume()).isEqualTo((Object)volume);
        Assertions.assertThat((BigDecimal)tops.getLastSalePrice()).isEqualTo((Object)lastSalePrice);
        Assertions.assertThat((BigDecimal)tops.getLastSaleSize()).isEqualTo((Object)lastSaleSize);
        Assertions.assertThat((Long)tops.getLastSaleTime()).isEqualTo((Object)lastSaleTime);
        Assertions.assertThat((Long)tops.getLastUpdated()).isEqualTo((Object)lastUpdated);
        Assertions.assertThat((String)tops.getSector()).isEqualTo((Object)sector);
        Assertions.assertThat((String)tops.getSecurityType()).isEqualTo((Object)securityType);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(TOPS.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(TOPS.class)).verify();
    }
}

