/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.refdata;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.refdata.FinancialStatus;
import pl.zankowski.iextrading4j.api.refdata.Flag;
import pl.zankowski.iextrading4j.api.refdata.IEXSymbolDirectory;
import pl.zankowski.iextrading4j.api.refdata.IssueSubType;
import pl.zankowski.iextrading4j.api.refdata.IssueType;
import pl.zankowski.iextrading4j.api.refdata.LuldTier;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class IEXSymbolDirectoryTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        String recordId = (String)this.fixture.create(String.class);
        LocalDateTime dailyListTimestamp = (LocalDateTime)this.fixture.create(LocalDateTime.class);
        String symbolInINETSymbology = (String)this.fixture.create(String.class);
        String symbolInCQSSymbology = (String)this.fixture.create(String.class);
        String symbolInCMSSymbology = (String)this.fixture.create(String.class);
        String securityName = (String)this.fixture.create(String.class);
        String companyName = (String)this.fixture.create(String.class);
        Flag testIssue = (Flag)this.fixture.create(Flag.class);
        String issueDescription = (String)this.fixture.create(String.class);
        IssueType issueType = (IssueType)this.fixture.create(IssueType.class);
        IssueSubType issueSubType = (IssueSubType)this.fixture.create(IssueSubType.class);
        String sicCode = (String)this.fixture.create(String.class);
        String transferAgent = (String)this.fixture.create(String.class);
        FinancialStatus financialStatus = (FinancialStatus)this.fixture.create(FinancialStatus.class);
        BigDecimal roundLotSize = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal previousOfficialClosingPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal adjustedPreviousOfficialClosingPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        Flag whenIssuedFlag = (Flag)this.fixture.create(Flag.class);
        Flag whenDistributedFlag = (Flag)this.fixture.create(Flag.class);
        Flag ipoFlag = (Flag)this.fixture.create(Flag.class);
        LocalDate firstDateListed = (LocalDate)this.fixture.create(LocalDate.class);
        LuldTier luldTierIndicator = (LuldTier)this.fixture.create(LuldTier.class);
        String countryOfIncorporation = (String)this.fixture.create(String.class);
        Flag leveragedETPFlag = (Flag)this.fixture.create(Flag.class);
        BigDecimal leveragedETPRatio = (BigDecimal)this.fixture.create(BigDecimal.class);
        Flag inverseETPFlag = (Flag)this.fixture.create(Flag.class);
        LocalDateTime recordUpdateTime = (LocalDateTime)this.fixture.create(LocalDateTime.class);
        IEXSymbolDirectory symbolDirectory = new IEXSymbolDirectory(recordId, dailyListTimestamp, symbolInINETSymbology, symbolInCQSSymbology, symbolInCMSSymbology, securityName, companyName, testIssue, issueDescription, issueType, issueSubType, sicCode, transferAgent, financialStatus, roundLotSize, previousOfficialClosingPrice, adjustedPreviousOfficialClosingPrice, whenIssuedFlag, whenDistributedFlag, ipoFlag, firstDateListed, luldTierIndicator, countryOfIncorporation, leveragedETPFlag, leveragedETPRatio, inverseETPFlag, recordUpdateTime);
        Assertions.assertThat((String)symbolDirectory.getRecordId()).isEqualTo((Object)recordId);
        Assertions.assertThat((LocalDateTime)symbolDirectory.getDailyListTimestamp()).isEqualTo((Object)dailyListTimestamp);
        Assertions.assertThat((String)symbolDirectory.getSymbolInINETSymbology()).isEqualTo((Object)symbolInINETSymbology);
        Assertions.assertThat((String)symbolDirectory.getSymbolInCQSSymbology()).isEqualTo((Object)symbolInCQSSymbology);
        Assertions.assertThat((String)symbolDirectory.getSymbolInCMSSymbology()).isEqualTo((Object)symbolInCMSSymbology);
        Assertions.assertThat((String)symbolDirectory.getSecurityName()).isEqualTo((Object)securityName);
        Assertions.assertThat((String)symbolDirectory.getCompanyName()).isEqualTo((Object)companyName);
        Assertions.assertThat((Comparable)symbolDirectory.getTestIssue()).isEqualTo((Object)testIssue);
        Assertions.assertThat((String)symbolDirectory.getIssueDescription()).isEqualTo((Object)issueDescription);
        Assertions.assertThat((Comparable)symbolDirectory.getIssueType()).isEqualTo((Object)issueType);
        Assertions.assertThat((Comparable)symbolDirectory.getIssueSubType()).isEqualTo((Object)issueSubType);
        Assertions.assertThat((String)symbolDirectory.getSicCode()).isEqualTo((Object)sicCode);
        Assertions.assertThat((String)symbolDirectory.getTransferAgent()).isEqualTo((Object)transferAgent);
        Assertions.assertThat((Comparable)symbolDirectory.getFinancialStatus()).isEqualTo((Object)financialStatus);
        Assertions.assertThat((BigDecimal)symbolDirectory.getRoundLotSize()).isEqualTo((Object)roundLotSize);
        Assertions.assertThat((BigDecimal)symbolDirectory.getPreviousOfficialClosingPrice()).isEqualTo((Object)previousOfficialClosingPrice);
        Assertions.assertThat((BigDecimal)symbolDirectory.getAdjustedPreviousOfficialClosingPrice()).isEqualTo((Object)adjustedPreviousOfficialClosingPrice);
        Assertions.assertThat((Comparable)symbolDirectory.getWhenIssuedFlag()).isEqualTo((Object)whenIssuedFlag);
        Assertions.assertThat((Comparable)symbolDirectory.getWhenDistributedFlag()).isEqualTo((Object)whenDistributedFlag);
        Assertions.assertThat((Comparable)symbolDirectory.getIpoFlag()).isEqualTo((Object)ipoFlag);
        Assertions.assertThat((LocalDate)symbolDirectory.getFirstDateListed()).isEqualTo((Object)firstDateListed);
        Assertions.assertThat((Comparable)symbolDirectory.getLuldTierIndicator()).isEqualTo((Object)luldTierIndicator);
        Assertions.assertThat((String)symbolDirectory.getCountryOfIncorporation()).isEqualTo((Object)countryOfIncorporation);
        Assertions.assertThat((Comparable)symbolDirectory.getLeveragedETPFlag()).isEqualTo((Object)leveragedETPFlag);
        Assertions.assertThat((BigDecimal)symbolDirectory.getLeveragedETPRatio()).isEqualTo((Object)leveragedETPRatio);
        Assertions.assertThat((Comparable)symbolDirectory.getInverseETPFlag()).isEqualTo((Object)inverseETPFlag);
        Assertions.assertThat((LocalDateTime)symbolDirectory.getRecordUpdateTime()).isEqualTo((Object)recordUpdateTime);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(IEXSymbolDirectory.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(IEXSymbolDirectory.class)).verify();
    }
}

