/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stats;

import com.flextrade.jfixture.JFixture;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stats.IntradayStat;
import pl.zankowski.iextrading4j.api.stats.IntradayStats;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class IntradayStatsTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        IntradayStat volume = (IntradayStat)this.fixture.create(IntradayStat.class);
        IntradayStat symbolsTraded = (IntradayStat)this.fixture.create(IntradayStat.class);
        IntradayStat routedVolume = (IntradayStat)this.fixture.create(IntradayStat.class);
        IntradayStat notional = (IntradayStat)this.fixture.create(IntradayStat.class);
        IntradayStat marketShare = (IntradayStat)this.fixture.create(IntradayStat.class);
        IntradayStats intradayStats = new IntradayStats(volume, symbolsTraded, routedVolume, notional, marketShare);
        Assertions.assertThat((Object)intradayStats.getVolume()).isEqualTo((Object)volume);
        Assertions.assertThat((Object)intradayStats.getSymbolsTraded()).isEqualTo((Object)symbolsTraded);
        Assertions.assertThat((Object)intradayStats.getRoutedVolume()).isEqualTo((Object)routedVolume);
        Assertions.assertThat((Object)intradayStats.getNotional()).isEqualTo((Object)notional);
        Assertions.assertThat((Object)intradayStats.getMarketShare()).isEqualTo((Object)marketShare);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(IntradayStats.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(IntradayStats.class)).verify();
    }
}

