/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stats;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stats.RecentStats;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class RecentStatsTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        LocalDate date = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal volume = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal routedVolume = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal marketShare = (BigDecimal)this.fixture.create(BigDecimal.class);
        Boolean isHalfday = (Boolean)this.fixture.create(Boolean.class);
        BigDecimal litVolume = (BigDecimal)this.fixture.create(BigDecimal.class);
        RecentStats recentStats = new RecentStats(date, volume, routedVolume, marketShare, isHalfday, litVolume);
        Assertions.assertThat((LocalDate)recentStats.getDate()).isEqualTo((Object)date);
        Assertions.assertThat((BigDecimal)recentStats.getVolume()).isEqualTo((Object)volume);
        Assertions.assertThat((BigDecimal)recentStats.getRoutedVolume()).isEqualTo((Object)routedVolume);
        Assertions.assertThat((BigDecimal)recentStats.getMarketShare()).isEqualTo((Object)marketShare);
        Assertions.assertThat((Boolean)recentStats.isHalfday()).isEqualTo((Object)isHalfday);
        Assertions.assertThat((BigDecimal)recentStats.getLitVolume()).isEqualTo((Object)litVolume);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(RecentStats.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(RecentStats.class)).verify();
    }
}

