/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.BarData;
import pl.zankowski.iextrading4j.api.stocks.BatchStocks;
import pl.zankowski.iextrading4j.api.stocks.Book;
import pl.zankowski.iextrading4j.api.stocks.Chart;
import pl.zankowski.iextrading4j.api.stocks.Company;
import pl.zankowski.iextrading4j.api.stocks.DelayedQuote;
import pl.zankowski.iextrading4j.api.stocks.Dividends;
import pl.zankowski.iextrading4j.api.stocks.Earnings;
import pl.zankowski.iextrading4j.api.stocks.EffectiveSpread;
import pl.zankowski.iextrading4j.api.stocks.Financials;
import pl.zankowski.iextrading4j.api.stocks.KeyStats;
import pl.zankowski.iextrading4j.api.stocks.LargestTrade;
import pl.zankowski.iextrading4j.api.stocks.Logo;
import pl.zankowski.iextrading4j.api.stocks.News;
import pl.zankowski.iextrading4j.api.stocks.Ohlc;
import pl.zankowski.iextrading4j.api.stocks.Quote;
import pl.zankowski.iextrading4j.api.stocks.Relevant;
import pl.zankowski.iextrading4j.api.stocks.ShortInterest;
import pl.zankowski.iextrading4j.api.stocks.Split;
import pl.zankowski.iextrading4j.api.stocks.ThresholdSecurities;
import pl.zankowski.iextrading4j.api.stocks.VenueVolume;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class BatchStocksTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        Book book = (Book)this.fixture.create(Book.class);
        ArrayList chart = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(Chart.class));
        Company company = (Company)this.fixture.create(Company.class);
        DelayedQuote delayedQuote = (DelayedQuote)this.fixture.create(DelayedQuote.class);
        ArrayList dividends = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(Dividends.class));
        Earnings earnings = (Earnings)this.fixture.create(Earnings.class);
        ArrayList effectiveSpread = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(EffectiveSpread.class));
        Financials financials = (Financials)this.fixture.create(Financials.class);
        ArrayList thresholdSecurities = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(ThresholdSecurities.class));
        ArrayList shortInterest = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(ShortInterest.class));
        KeyStats keyStats = (KeyStats)this.fixture.create(KeyStats.class);
        ArrayList largestTrades = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(LargestTrade.class));
        Logo logo = (Logo)this.fixture.create(Logo.class);
        ArrayList news = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(News.class));
        Ohlc ohlc = (Ohlc)this.fixture.create(Ohlc.class);
        ArrayList peers = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(String.class));
        BarData previous = (BarData)this.fixture.create(BarData.class);
        BigDecimal price = (BigDecimal)this.fixture.create(BigDecimal.class);
        Quote quote = (Quote)this.fixture.create(Quote.class);
        Relevant relevant = (Relevant)this.fixture.create(Relevant.class);
        ArrayList splits = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(Split.class));
        ArrayList venueVolume = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(VenueVolume.class));
        BatchStocks batchStocks = new BatchStocks(book, (List)chart, company, delayedQuote, (List)dividends, earnings, (List)effectiveSpread, financials, (List)thresholdSecurities, (List)shortInterest, keyStats, (List)largestTrades, logo, (List)news, ohlc, (List)peers, previous, price, quote, relevant, (List)splits, (List)venueVolume);
        Assertions.assertThat((Object)batchStocks.getBook()).isEqualTo((Object)book);
        Assertions.assertThat((List)batchStocks.getChart()).isEqualTo((Object)chart);
        Assertions.assertThat((Object)batchStocks.getCompany()).isEqualTo((Object)company);
        Assertions.assertThat((Object)batchStocks.getDelayedQuote()).isEqualTo((Object)delayedQuote);
        Assertions.assertThat((List)batchStocks.getDividends()).isEqualTo((Object)dividends);
        Assertions.assertThat((Object)batchStocks.getEarnings()).isEqualTo((Object)earnings);
        Assertions.assertThat((List)batchStocks.getEffectiveSpread()).isEqualTo((Object)effectiveSpread);
        Assertions.assertThat((Object)batchStocks.getFinancials()).isEqualTo((Object)financials);
        Assertions.assertThat((List)batchStocks.getThresholdSecurities()).isEqualTo((Object)thresholdSecurities);
        Assertions.assertThat((List)batchStocks.getShortInterest()).isEqualTo((Object)shortInterest);
        Assertions.assertThat((Object)batchStocks.getKeyStats()).isEqualTo((Object)keyStats);
        Assertions.assertThat((List)batchStocks.getLargestTrades()).isEqualTo((Object)largestTrades);
        Assertions.assertThat((Object)batchStocks.getLogo()).isEqualTo((Object)logo);
        Assertions.assertThat((List)batchStocks.getNews()).isEqualTo((Object)news);
        Assertions.assertThat((Object)batchStocks.getOhlc()).isEqualTo((Object)ohlc);
        Assertions.assertThat((List)batchStocks.getPeers()).isEqualTo((Object)peers);
        Assertions.assertThat((Object)batchStocks.getPrevious()).isEqualTo((Object)previous);
        Assertions.assertThat((BigDecimal)batchStocks.getPrice()).isEqualTo((Object)price);
        Assertions.assertThat((Object)batchStocks.getQuote()).isEqualTo((Object)quote);
        Assertions.assertThat((Object)batchStocks.getRelevant()).isEqualTo((Object)relevant);
        Assertions.assertThat((List)batchStocks.getSplits()).isEqualTo((Object)splits);
        Assertions.assertThat((List)batchStocks.getVenueVolume()).isEqualTo((Object)venueVolume);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(BatchStocks.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(BatchStocks.class)).verify();
    }
}

