/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.DelayedQuote;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class DelayedQuoteTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        String symbol = (String)this.fixture.create(String.class);
        BigDecimal delayedPrice = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal high = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal low = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal delayedSize = (BigDecimal)this.fixture.create(BigDecimal.class);
        Long delayedPriceTime = (Long)this.fixture.create(Long.class);
        BigDecimal totalVolume = (BigDecimal)this.fixture.create(BigDecimal.class);
        Long processedTime = (Long)this.fixture.create(Long.class);
        DelayedQuote delayedQuote = new DelayedQuote(symbol, delayedPrice, high, low, delayedSize, delayedPriceTime, totalVolume, processedTime);
        Assertions.assertThat((String)delayedQuote.getSymbol()).isEqualTo((Object)symbol);
        Assertions.assertThat((BigDecimal)delayedQuote.getDelayedPrice()).isEqualTo((Object)delayedPrice);
        Assertions.assertThat((BigDecimal)delayedQuote.getHigh()).isEqualTo((Object)high);
        Assertions.assertThat((BigDecimal)delayedQuote.getLow()).isEqualTo((Object)low);
        Assertions.assertThat((BigDecimal)delayedQuote.getDelayedSize()).isEqualTo((Object)delayedSize);
        Assertions.assertThat((Long)delayedQuote.getDelayedPriceTime()).isEqualTo((Object)delayedPriceTime);
        Assertions.assertThat((BigDecimal)delayedQuote.getTotalVolume()).isEqualTo((Object)totalVolume);
        Assertions.assertThat((Long)delayedQuote.getProcessedTime()).isEqualTo((Object)processedTime);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(DelayedQuote.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(DelayedQuote.class)).verify();
    }
}

