/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.DividendQualification;
import pl.zankowski.iextrading4j.api.stocks.DividendType;
import pl.zankowski.iextrading4j.api.stocks.Dividends;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class DividendsTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        LocalDate exDate = (LocalDate)this.fixture.create(LocalDate.class);
        LocalDate paymentDate = (LocalDate)this.fixture.create(LocalDate.class);
        LocalDate recordDate = (LocalDate)this.fixture.create(LocalDate.class);
        LocalDate declaredDate = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal amount = (BigDecimal)this.fixture.create(BigDecimal.class);
        String flag = (String)this.fixture.create(String.class);
        DividendType dividendType = (DividendType)this.fixture.create(DividendType.class);
        DividendQualification qualification = (DividendQualification)this.fixture.create(DividendQualification.class);
        String indicated = (String)this.fixture.create(String.class);
        Dividends dividends = new Dividends(exDate, paymentDate, recordDate, declaredDate, amount, flag, dividendType, qualification, indicated);
        Assertions.assertThat((LocalDate)dividends.getExDate()).isEqualTo((Object)exDate);
        Assertions.assertThat((LocalDate)dividends.getPaymentDate()).isEqualTo((Object)paymentDate);
        Assertions.assertThat((LocalDate)dividends.getRecordDate()).isEqualTo((Object)recordDate);
        Assertions.assertThat((LocalDate)dividends.getDeclaredDate()).isEqualTo((Object)declaredDate);
        Assertions.assertThat((BigDecimal)dividends.getAmount()).isEqualTo((Object)amount);
        Assertions.assertThat((String)dividends.getFlag()).isEqualTo((Object)flag);
        Assertions.assertThat((Comparable)dividends.getType()).isEqualTo((Object)dividendType);
        Assertions.assertThat((Comparable)dividends.getQualified()).isEqualTo((Object)qualification);
        Assertions.assertThat((String)dividends.getIndicated()).isEqualTo((Object)indicated);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Dividends.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Dividends.class)).verify();
    }
}

