/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.Financial;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class FinancialTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        LocalDate reportDate = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal grossProfit = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal costOfRevenue = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal operatingRevenue = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal totalRevenue = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal operatingIncome = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal netIncome = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal researchAndDevelopment = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal operatingExpense = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal currentAssets = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal totalAssets = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal totalLiabilities = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal currentCash = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal currentDebt = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal totalCash = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal totalDebt = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal shareholderEquity = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal cashChange = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal cashFlow = (BigDecimal)this.fixture.create(BigDecimal.class);
        String operatingGainsLosses = (String)this.fixture.create(String.class);
        Financial financial = new Financial(reportDate, grossProfit, costOfRevenue, operatingRevenue, totalRevenue, operatingIncome, netIncome, researchAndDevelopment, operatingExpense, currentAssets, totalAssets, totalLiabilities, currentCash, currentDebt, totalCash, totalDebt, shareholderEquity, cashChange, cashFlow, operatingGainsLosses);
        Assertions.assertThat((LocalDate)financial.getReportDate()).isEqualTo((Object)reportDate);
        Assertions.assertThat((BigDecimal)financial.getGrossProfit()).isEqualTo((Object)grossProfit);
        Assertions.assertThat((BigDecimal)financial.getCostOfRevenue()).isEqualTo((Object)costOfRevenue);
        Assertions.assertThat((BigDecimal)financial.getOperatingRevenue()).isEqualTo((Object)operatingRevenue);
        Assertions.assertThat((BigDecimal)financial.getTotalRevenue()).isEqualTo((Object)totalRevenue);
        Assertions.assertThat((BigDecimal)financial.getOperatingIncome()).isEqualTo((Object)operatingIncome);
        Assertions.assertThat((BigDecimal)financial.getNetIncome()).isEqualTo((Object)netIncome);
        Assertions.assertThat((BigDecimal)financial.getResearchAndDevelopment()).isEqualTo((Object)researchAndDevelopment);
        Assertions.assertThat((BigDecimal)financial.getOperatingExpense()).isEqualTo((Object)operatingExpense);
        Assertions.assertThat((BigDecimal)financial.getCurrentAssets()).isEqualTo((Object)currentAssets);
        Assertions.assertThat((BigDecimal)financial.getTotalAssets()).isEqualTo((Object)totalAssets);
        Assertions.assertThat((BigDecimal)financial.getTotalLiabilities()).isEqualTo((Object)totalLiabilities);
        Assertions.assertThat((BigDecimal)financial.getCurrentCash()).isEqualTo((Object)currentCash);
        Assertions.assertThat((BigDecimal)financial.getCurrentDebt()).isEqualTo((Object)currentDebt);
        Assertions.assertThat((BigDecimal)financial.getTotalCash()).isEqualTo((Object)totalCash);
        Assertions.assertThat((BigDecimal)financial.getTotalDebt()).isEqualTo((Object)totalDebt);
        Assertions.assertThat((BigDecimal)financial.getShareholderEquity()).isEqualTo((Object)shareholderEquity);
        Assertions.assertThat((BigDecimal)financial.getCashChange()).isEqualTo((Object)cashChange);
        Assertions.assertThat((BigDecimal)financial.getCashFlow()).isEqualTo((Object)cashFlow);
        Assertions.assertThat((String)financial.getOperatingGainsLosses()).isEqualTo((Object)operatingGainsLosses);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Financial.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Financial.class)).verify();
    }
}

