/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalTime;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.LargestTrade;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class LargestTradeTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal price = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal size = (BigDecimal)this.fixture.create(BigDecimal.class);
        Long time = (Long)this.fixture.create(Long.class);
        LocalTime timeLabel = (LocalTime)this.fixture.create(LocalTime.class);
        String venue = (String)this.fixture.create(String.class);
        String venueName = (String)this.fixture.create(String.class);
        LargestTrade largestTrade = new LargestTrade(price, size, time, timeLabel, venue, venueName);
        Assertions.assertThat((BigDecimal)largestTrade.getPrice()).isEqualTo((Object)price);
        Assertions.assertThat((BigDecimal)largestTrade.getSize()).isEqualTo((Object)size);
        Assertions.assertThat((Long)largestTrade.getTime()).isEqualTo((Object)time);
        Assertions.assertThat((LocalTime)largestTrade.getTimeLabel()).isEqualTo((Object)timeLabel);
        Assertions.assertThat((String)largestTrade.getVenue()).isEqualTo((Object)venue);
        Assertions.assertThat((String)largestTrade.getVenueName()).isEqualTo((Object)venueName);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(LargestTrade.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(LargestTrade.class)).verify();
    }
}

