/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.Ohlc;
import pl.zankowski.iextrading4j.api.stocks.Point;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class OhlcTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        Point open = (Point)this.fixture.create(Point.class);
        Point close = (Point)this.fixture.create(Point.class);
        BigDecimal high = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal low = (BigDecimal)this.fixture.create(BigDecimal.class);
        Ohlc ohlc = new Ohlc(open, close, high, low);
        Assertions.assertThat((Object)ohlc.getOpen()).isEqualTo((Object)open);
        Assertions.assertThat((Object)ohlc.getClose()).isEqualTo((Object)close);
        Assertions.assertThat((BigDecimal)ohlc.getHigh()).isEqualTo((Object)high);
        Assertions.assertThat((BigDecimal)ohlc.getLow()).isEqualTo((Object)low);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Ohlc.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Ohlc.class)).verify();
    }
}

