/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.refdata.Flag;
import pl.zankowski.iextrading4j.api.stocks.ShortInterest;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class ShortInterestTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        LocalDate settlementDate = (LocalDate)this.fixture.create(LocalDate.class);
        String symbolInINETSymbology = (String)this.fixture.create(String.class);
        String symbolInCQSSymbology = (String)this.fixture.create(String.class);
        String symbolInCMSSymbology = (String)this.fixture.create(String.class);
        String cusip = (String)this.fixture.create(String.class);
        String securityName = (String)this.fixture.create(String.class);
        String companyName = (String)this.fixture.create(String.class);
        BigDecimal currentShortInterest = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal previousShortInterest = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal percentChange = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal averageDailyVolume = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal daystoCover = (BigDecimal)this.fixture.create(BigDecimal.class);
        Flag stockAdjustmentFlag = (Flag)this.fixture.create(Flag.class);
        Flag newIssueFlag = (Flag)this.fixture.create(Flag.class);
        Flag revisionFlag = (Flag)this.fixture.create(Flag.class);
        ShortInterest shortInterest = new ShortInterest(settlementDate, symbolInINETSymbology, symbolInCQSSymbology, symbolInCMSSymbology, cusip, securityName, companyName, currentShortInterest, previousShortInterest, percentChange, averageDailyVolume, daystoCover, stockAdjustmentFlag, newIssueFlag, revisionFlag);
        Assertions.assertThat((LocalDate)shortInterest.getSettlementDate()).isEqualTo((Object)settlementDate);
        Assertions.assertThat((String)shortInterest.getSymbolInINETSymbology()).isEqualTo((Object)symbolInINETSymbology);
        Assertions.assertThat((String)shortInterest.getSymbolInCQSSymbology()).isEqualTo((Object)symbolInCQSSymbology);
        Assertions.assertThat((String)shortInterest.getSymbolInCMSSymbology()).isEqualTo((Object)symbolInCMSSymbology);
        Assertions.assertThat((String)shortInterest.getCusip()).isEqualTo((Object)cusip);
        Assertions.assertThat((String)shortInterest.getSecurityName()).isEqualTo((Object)securityName);
        Assertions.assertThat((String)shortInterest.getCompanyName()).isEqualTo((Object)companyName);
        Assertions.assertThat((BigDecimal)shortInterest.getCurrentShortInterest()).isEqualTo((Object)currentShortInterest);
        Assertions.assertThat((BigDecimal)shortInterest.getPreviousShortInterest()).isEqualTo((Object)previousShortInterest);
        Assertions.assertThat((BigDecimal)shortInterest.getPercentChange()).isEqualTo((Object)percentChange);
        Assertions.assertThat((BigDecimal)shortInterest.getAverageDailyVolume()).isEqualTo((Object)averageDailyVolume);
        Assertions.assertThat((BigDecimal)shortInterest.getDaystoCover()).isEqualTo((Object)daystoCover);
        Assertions.assertThat((Comparable)shortInterest.getStockAdjustmentFlag()).isEqualTo((Object)stockAdjustmentFlag);
        Assertions.assertThat((Comparable)shortInterest.getNewIssueFlag()).isEqualTo((Object)newIssueFlag);
        Assertions.assertThat((Comparable)shortInterest.getRevisionFlag()).isEqualTo((Object)revisionFlag);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(ShortInterest.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(ShortInterest.class)).verify();
    }
}

