/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.Split;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class SplitTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        LocalDate exDate = (LocalDate)this.fixture.create(LocalDate.class);
        LocalDate declaredDate = (LocalDate)this.fixture.create(LocalDate.class);
        LocalDate recordDate = (LocalDate)this.fixture.create(LocalDate.class);
        LocalDate paymentDate = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal ratio = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal toFactor = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal forFactor = (BigDecimal)this.fixture.create(BigDecimal.class);
        Split split = new Split(exDate, declaredDate, recordDate, paymentDate, ratio, toFactor, forFactor);
        Assertions.assertThat((LocalDate)split.getExDate()).isEqualTo((Object)exDate);
        Assertions.assertThat((LocalDate)split.getDeclaredDate()).isEqualTo((Object)declaredDate);
        Assertions.assertThat((LocalDate)split.getRecordDate()).isEqualTo((Object)recordDate);
        Assertions.assertThat((LocalDate)split.getPaymentDate()).isEqualTo((Object)paymentDate);
        Assertions.assertThat((BigDecimal)split.getRatio()).isEqualTo((Object)ratio);
        Assertions.assertThat((BigDecimal)split.getToFactor()).isEqualTo((Object)toFactor);
        Assertions.assertThat((BigDecimal)split.getForFactor()).isEqualTo((Object)forFactor);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Split.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Split.class)).verify();
    }
}

