/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.Ipo;
import pl.zankowski.iextrading4j.api.stocks.IpoSummary;
import pl.zankowski.iextrading4j.api.stocks.TodayIpos;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class TodayIposTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        ArrayList rawData = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(Ipo.class));
        ArrayList viewData = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(IpoSummary.class));
        LocalDate lastUpdated = (LocalDate)this.fixture.create(LocalDate.class);
        TodayIpos todayIpos = new TodayIpos((List)rawData, (List)viewData, lastUpdated);
        Assertions.assertThat((List)todayIpos.getRawData()).isEqualTo((Object)rawData);
        Assertions.assertThat((List)todayIpos.getViewData()).isEqualTo((Object)viewData);
        Assertions.assertThat((LocalDate)todayIpos.getLastUpdate()).isEqualTo((Object)lastUpdated);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(TodayIpos.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(TodayIpos.class)).verify();
    }
}

