/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.VenueVolume;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class VenueVolumeTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal volume = (BigDecimal)this.fixture.create(BigDecimal.class);
        String venue = (String)this.fixture.create(String.class);
        String venueName = (String)this.fixture.create(String.class);
        LocalDate date = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal marketPercent = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal avgMarketPercent = (BigDecimal)this.fixture.create(BigDecimal.class);
        VenueVolume venueVolume = new VenueVolume(volume, venue, venueName, date, marketPercent, avgMarketPercent);
        Assertions.assertThat((BigDecimal)venueVolume.getVolume()).isEqualTo((Object)volume);
        Assertions.assertThat((String)venueVolume.getVenue()).isEqualTo((Object)venue);
        Assertions.assertThat((String)venueVolume.getVenueName()).isEqualTo((Object)venueName);
        Assertions.assertThat((LocalDate)venueVolume.getDate()).isEqualTo((Object)date);
        Assertions.assertThat((BigDecimal)venueVolume.getMarketPercent()).isEqualTo((Object)marketPercent);
        Assertions.assertThat((BigDecimal)venueVolume.getAvgMarketPercent()).isEqualTo((Object)avgMarketPercent);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(VenueVolume.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(VenueVolume.class)).verify();
    }
}

