/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.client;

import com.google.common.collect.Lists;
import io.grpc.ClientInterceptor;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import plus.jdk.grpc.annotation.GrpcClient;
import plus.jdk.grpc.client.GrpcSubClientFactory;
import plus.jdk.grpc.config.GrpcPlusClientProperties;

public class GrpcClientBeanPostProcessor
implements BeanPostProcessor {
    private final ApplicationContext applicationContext;
    private final GrpcSubClientFactory grpcSubClientFactory;
    private final GrpcPlusClientProperties properties;

    public GrpcClientBeanPostProcessor(ApplicationContext context, GrpcSubClientFactory grpcSubClientFactory, GrpcPlusClientProperties properties) {
        this.applicationContext = context;
        this.grpcSubClientFactory = grpcSubClientFactory;
        this.properties = properties;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (bean instanceof Advised) {
            clazz = bean.getClass().getSuperclass();
            Advised advised = (Advised)bean;
            try {
                Object rawBean = advised.getTargetSource().getTarget();
                Class<?> rawClazz = bean.getClass().getSuperclass();
                this.processFields(rawClazz, rawBean);
                this.processMethods(rawClazz, rawBean);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.processFields(clazz, bean);
        this.processMethods(clazz, bean);
        return bean;
    }

    private void processFields(Class<?> clazz, Object bean) {
        for (Field field : clazz.getDeclaredFields()) {
            GrpcClient annotation = (GrpcClient)AnnotationUtils.findAnnotation((AnnotatedElement)field, GrpcClient.class);
            if (annotation == null) continue;
            if (!AbstractStub.class.isAssignableFrom(field.getType())) {
                throw new BeanInstantiationException(field.getType(), "Unsupported grpc stub or channel type");
            }
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)bean, this.processInjectionPoint(field.getType(), annotation));
        }
    }

    private void processMethods(Class<?> clazz, Object bean) {
        for (Method method : clazz.getDeclaredMethods()) {
            GrpcClient annotation = (GrpcClient)AnnotationUtils.findAnnotation((Method)method, GrpcClient.class);
            if (annotation == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1) {
                throw new BeanDefinitionStoreException("Method " + method + " doesn't have exactly one parameter.");
            }
            for (Class<?> paramType : paramTypes) {
                if (!AbstractStub.class.isAssignableFrom(paramType)) {
                    throw new BeanInstantiationException(paramType, "Unsupported grpc stub or channel type");
                }
                ReflectionUtils.makeAccessible((Method)method);
                ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{this.processInjectionPoint(paramTypes[0], annotation)});
            }
        }
    }

    protected <T extends AbstractStub<T>> T processInjectionPoint(Class<T> injectionType, GrpcClient annotation) {
        Environment environment = this.applicationContext.getEnvironment();
        List<ClientInterceptor> interceptors = this.interceptorsFromAnnotation(annotation);
        String address = annotation.value();
        if (!StringUtils.hasText((String)address)) {
            address = this.properties.getDefaultService();
        }
        if (address.startsWith("${") && address.endsWith("}")) {
            address = environment.getProperty(address.substring(2, address.length() - 1));
        } else {
            try {
                URI uri = URI.create(address);
                if (!uri.isAbsolute()) {
                    address = environment.getProperty(address);
                }
            }
            catch (Exception e) {
                address = environment.getProperty(address);
            }
        }
        return this.grpcSubClientFactory.createStub(injectionType, address, interceptors.toArray(new ClientInterceptor[0]));
    }

    protected List<ClientInterceptor> interceptorsFromAnnotation(GrpcClient grpcClient) {
        ArrayList list = Lists.newArrayList();
        for (Class<? extends ClientInterceptor> interceptorClass : grpcClient.interceptors()) {
            ClientInterceptor clientInterceptor;
            if (this.applicationContext.getBeanNamesForType(interceptorClass).length > 0) {
                clientInterceptor = (ClientInterceptor)this.applicationContext.getBean(interceptorClass);
            } else {
                try {
                    clientInterceptor = interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new BeanCreationException("Failed to create interceptor instance", (Throwable)e);
                }
            }
            list.add(clientInterceptor);
        }
        return list;
    }
}

