/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.client;

import com.google.common.collect.ImmutableList;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.util.CollectionUtils;
import plus.jdk.grpc.client.INameResolverConfigurer;
import plus.jdk.grpc.config.GrpcPlusClientProperties;
import plus.jdk.grpc.model.GrpcNameResolverModel;

public class GrpcNameResolver
extends NameResolver {
    private NameResolver.ResolutionResult result;
    private final URI targetUri;
    private NameResolver.Listener2 listener;
    private final GrpcPlusClientProperties properties;
    private List<EquivalentAddressGroup> addressGroupList = new ArrayList<EquivalentAddressGroup>();
    private final Collection<INameResolverConfigurer> nameResolverConfigurers;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(10);

    public GrpcNameResolver(GrpcPlusClientProperties properties, URI targetUri, GrpcNameResolverModel nameResolver, Collection<INameResolverConfigurer> nameResolverConfigurers) {
        this.nameResolverConfigurers = nameResolverConfigurers;
        this.properties = properties;
        this.addressGroupList = nameResolver.toEquivalentAddressGroups();
        this.targetUri = targetUri;
        this.result = NameResolver.ResolutionResult.newBuilder().setAddresses((List)ImmutableList.copyOf(this.addressGroupList)).build();
    }

    public String getServiceAuthority() {
        if (this.targetUri.getAuthority() == null) {
            return this.targetUri.getHost();
        }
        return this.targetUri.getAuthority();
    }

    public void start(NameResolver.Listener2 listener) {
        this.listener = listener;
        this.listener.onResult(this.result);
        if (CollectionUtils.isEmpty(this.nameResolverConfigurers)) {
            return;
        }
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            ArrayList<EquivalentAddressGroup> results = new ArrayList<EquivalentAddressGroup>();
            for (INameResolverConfigurer configurer : this.nameResolverConfigurers) {
                results.addAll(configurer.configurationName(this.targetUri));
            }
            if (results.size() == 0) {
                return;
            }
            this.addressGroupList = results;
            this.result = NameResolver.ResolutionResult.newBuilder().setAddresses((List)ImmutableList.copyOf(this.addressGroupList)).build();
            this.listener.onResult(this.result);
        }, this.properties.getNameRefreshRate().intValue(), this.properties.getNameRefreshRate().intValue(), TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }
}

