/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.client;

import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import plus.jdk.grpc.client.GrpcNameResolver;
import plus.jdk.grpc.client.INameResolverConfigurer;
import plus.jdk.grpc.config.GrpcPlusClientProperties;
import plus.jdk.grpc.model.GrpcNameResolverModel;

public class GrpcNameResolverProvider
extends NameResolverProvider {
    private final GrpcPlusClientProperties properties;
    private String scheme = "grpc";
    private final Map<String, GrpcNameResolverModel> nameResolverMap = new HashMap<String, GrpcNameResolverModel>();
    private final Collection<INameResolverConfigurer> nameResolverConfigurers;

    public GrpcNameResolverProvider(GrpcPlusClientProperties grpcClientProperties, String scheme, Collection<INameResolverConfigurer> nameResolverConfigurers) {
        this.properties = grpcClientProperties;
        this.scheme = scheme;
        this.nameResolverConfigurers = nameResolverConfigurers;
        for (GrpcNameResolverModel nameResolver : this.properties.getResolvers()) {
            if (!nameResolver.getScheme().equals(scheme)) continue;
            this.nameResolverMap.put(nameResolver.getServiceName(), nameResolver);
        }
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        GrpcNameResolverModel nameResolverModel = this.nameResolverMap.get(targetUri.getHost());
        if (!targetUri.getScheme().equals(this.scheme) || nameResolverModel == null) {
            return null;
        }
        return new GrpcNameResolver(this.properties, targetUri, nameResolverModel, this.nameResolverConfigurers);
    }

    public String getDefaultScheme() {
        return this.scheme;
    }
}

