/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.client;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import io.grpc.stub.AbstractStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import plus.jdk.grpc.client.GrpcNameResolverProvider;
import plus.jdk.grpc.client.INameResolverConfigurer;
import plus.jdk.grpc.client.factory.FallbackStubFactory;
import plus.jdk.grpc.client.factory.StandardGrpcStubFactory;
import plus.jdk.grpc.config.GrpcPlusClientProperties;
import plus.jdk.grpc.global.GrpcClientInterceptorConfigurer;
import plus.jdk.grpc.model.GrpcNameResolverModel;

public class GrpcSubClientFactory {
    private final ApplicationContext applicationContext;
    private List<StandardGrpcStubFactory> stubFactories = null;
    private final GrpcPlusClientProperties properties;
    private final ConfigurableBeanFactory configurableBeanFactory;
    private final Collection<INameResolverConfigurer> nameResolverConfigurers;

    public GrpcSubClientFactory(ApplicationContext applicationContext, GrpcPlusClientProperties properties) {
        this.applicationContext = applicationContext;
        this.configurableBeanFactory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        this.properties = properties;
        this.nameResolverConfigurers = applicationContext.getBeansOfType(INameResolverConfigurer.class).values();
        for (INameResolverConfigurer configurer : this.nameResolverConfigurers) {
            configurer.configureNameResolvers(properties.getResolvers());
        }
        HashMap<String, GrpcNameResolverModel> nameResolverMap = new HashMap<String, GrpcNameResolverModel>();
        for (GrpcNameResolverModel nameResolver : properties.getResolvers()) {
            if (nameResolverMap.containsKey(nameResolver.getScheme())) continue;
            NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)new GrpcNameResolverProvider(properties, nameResolver.getScheme(), this.nameResolverConfigurers));
            nameResolverMap.put(nameResolver.getScheme(), nameResolver);
        }
    }

    public <T extends AbstractStub<T>> String getBeanName(Class<T> stubClass, String address) {
        return stubClass.getName() + "->" + address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractStub<T>> T createStub(Class<T> stubClass, ManagedChannelBuilder<?> channelBuilder, String address) {
        StandardGrpcStubFactory factory = this.getStubFactories().stream().filter(stubFactory -> stubFactory.isApplicable(stubClass)).findFirst().orElseThrow(() -> new BeanInstantiationException(stubClass, "Unsupported stub type: " + stubClass.getName() + " -> Please report this issue."));
        try {
            AbstractStub stub;
            String beanName = this.getBeanName(stubClass, address);
            if (this.configurableBeanFactory.containsBean(beanName)) {
                return (T)((AbstractStub)this.configurableBeanFactory.getBean(stubClass));
            }
            Class clazz = stubClass;
            synchronized (clazz) {
                if (this.configurableBeanFactory.containsBean(beanName)) {
                    return (T)((AbstractStub)this.configurableBeanFactory.getBean(stubClass));
                }
                ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
                for (GrpcClientInterceptorConfigurer configurer : this.applicationContext.getBeansOfType(GrpcClientInterceptorConfigurer.class).values()) {
                    configurer.configureClientInterceptors(interceptors);
                }
                channelBuilder.intercept(interceptors);
                channelBuilder.usePlaintext();
                ManagedChannel channel = channelBuilder.build();
                stub = (AbstractStub)stubClass.cast(factory.createStub(stubClass, (Channel)channel));
                this.configurableBeanFactory.registerSingleton(beanName, (Object)stub);
            }
            return (T)stub;
        }
        catch (Exception exception) {
            throw new BeanInstantiationException(stubClass, "Failed to create gRPC stub of type " + stubClass.getName(), (Throwable)exception);
        }
    }

    public <T extends AbstractStub<T>> T createStub(Class<T> stubClass, String address, ClientInterceptor ... interceptors) {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forTarget((String)address);
        channelBuilder.usePlaintext();
        return this.createStub(stubClass, channelBuilder, address);
    }

    private List<StandardGrpcStubFactory> getStubFactories() {
        if (this.stubFactories == null) {
            this.stubFactories = new ArrayList(this.applicationContext.getBeansOfType(StandardGrpcStubFactory.class).values());
            this.stubFactories.add(new FallbackStubFactory());
        }
        return this.stubFactories;
    }
}

