/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.client.factory;

import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.springframework.beans.BeanInstantiationException;
import plus.jdk.grpc.client.factory.StandardGrpcStubFactory;

public final class FallbackStubFactory
extends StandardGrpcStubFactory {
    @Override
    public boolean isApplicable(Class<? extends AbstractStub<?>> stubType) {
        return true;
    }

    @Override
    public <T extends AbstractStub<T>> AbstractStub<T> createStub(Class<T> stubType, Channel channel) {
        try {
            Class<?> declaringClass = stubType.getDeclaringClass();
            if (declaringClass != null) {
                for (Method method : declaringClass.getMethods()) {
                    String name = method.getName();
                    int modifiers = method.getModifiers();
                    Parameter[] parameters = method.getParameters();
                    if (!name.startsWith("new") || !name.endsWith("Stub") || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !method.getReturnType().isAssignableFrom(stubType) || parameters.length != 1 || !Channel.class.equals(parameters[0].getType())) continue;
                    return (AbstractStub)AbstractStub.class.cast(method.invoke(null, channel));
                }
            }
            Constructor<T> constructor = stubType.getConstructor(Channel.class);
            return (AbstractStub)constructor.newInstance(channel);
        }
        catch (Exception e) {
            throw new BeanInstantiationException(stubType, "Failed to create gRPC client via FallbackStubFactory", (Throwable)e);
        }
    }
}

