/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.client.factory;

import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.Method;
import org.springframework.beans.BeanInstantiationException;

public abstract class StandardGrpcStubFactory {
    public <T extends AbstractStub<T>> AbstractStub<T> createStub(Class<T> stubType, Channel channel) {
        try {
            String methodName = this.getFactoryMethodName();
            Class<?> enclosingClass = stubType.getEnclosingClass();
            Method factoryMethod = enclosingClass.getMethod(methodName, Channel.class);
            return (AbstractStub)stubType.cast(factoryMethod.invoke(null, channel));
        }
        catch (Exception e) {
            throw new BeanInstantiationException(stubType, "Failed to create gRPC client", (Throwable)e);
        }
    }

    protected String getFactoryMethodName() {
        return null;
    }

    public abstract boolean isApplicable(Class<? extends AbstractStub<?>> var1);
}

