/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.common;

import io.grpc.MethodDescriptor;

public final class GrpcUtils {
    public static final String DOMAIN_SOCKET_ADDRESS_SCHEME = "unix";
    public static final String DOMAIN_SOCKET_ADDRESS_PREFIX = "unix:";
    public static final String CLOUD_DISCOVERY_METADATA_PORT = "gRPC_port";
    public static final int INTER_PROCESS_DISABLE = -1;

    public static String extractDomainSocketAddressPath(String address) {
        if (!address.startsWith(DOMAIN_SOCKET_ADDRESS_PREFIX)) {
            throw new IllegalArgumentException(address + " is not a valid domain socket address.");
        }
        String path = address.substring(DOMAIN_SOCKET_ADDRESS_PREFIX.length());
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        return path;
    }

    public static String extractServiceName(MethodDescriptor<?, ?> method) {
        return MethodDescriptor.extractFullServiceName((String)method.getFullMethodName());
    }

    public static String extractMethodName(MethodDescriptor<?, ?> method) {
        String fullMethodName = method.getFullMethodName();
        int index = fullMethodName.lastIndexOf(47);
        if (index == -1) {
            return fullMethodName;
        }
        return fullMethodName.substring(index + 1);
    }

    private GrpcUtils() {
    }
}

