/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@ConfigurationProperties(prefix="plus.jdk.grpc")
public class GrpcPlusProperties {
    public static final String ANY_IP_ADDRESS = "*";
    public static final String ANY_IPv4_ADDRESS = "0.0.0.0";
    public static final String ANY_IPv6_ADDRESS = "::";
    private boolean enabled = false;
    private Integer port = 10240;
    private String serviceUri = "my-grpc://service-name";
    private Integer masterThreadNum = 1;
    private Integer workerThreadNum = 0;
    private String address = "*";
    private Integer serviceRegisterThreadNum = 2;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration serviceRegisterInterval = Duration.of(5000L, ChronoUnit.MILLIS);
    private boolean enableKeepAlive;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTime = Duration.of(2L, ChronoUnit.HOURS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTimeout = Duration.of(20L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration permitKeepAliveTime = Duration.of(5L, ChronoUnit.MINUTES);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private boolean permitKeepAliveWithoutCalls = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxConnectionIdle = null;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxConnectionAge = null;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxConnectionAgeGrace = null;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMessageSize = null;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMetadataSize = null;
    private boolean healthServiceEnabled = true;
    private boolean reflectionServiceEnabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public Integer getMasterThreadNum() {
        return this.masterThreadNum;
    }

    public Integer getWorkerThreadNum() {
        return this.workerThreadNum;
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getServiceRegisterThreadNum() {
        return this.serviceRegisterThreadNum;
    }

    public Duration getServiceRegisterInterval() {
        return this.serviceRegisterInterval;
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Duration getPermitKeepAliveTime() {
        return this.permitKeepAliveTime;
    }

    public boolean isPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    public Duration getMaxConnectionIdle() {
        return this.maxConnectionIdle;
    }

    public Duration getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    public Duration getMaxConnectionAgeGrace() {
        return this.maxConnectionAgeGrace;
    }

    public DataSize getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public DataSize getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public boolean isHealthServiceEnabled() {
        return this.healthServiceEnabled;
    }

    public boolean isReflectionServiceEnabled() {
        return this.reflectionServiceEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
    }

    public void setMasterThreadNum(Integer masterThreadNum) {
        this.masterThreadNum = masterThreadNum;
    }

    public void setWorkerThreadNum(Integer workerThreadNum) {
        this.workerThreadNum = workerThreadNum;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setServiceRegisterThreadNum(Integer serviceRegisterThreadNum) {
        this.serviceRegisterThreadNum = serviceRegisterThreadNum;
    }

    public void setServiceRegisterInterval(Duration serviceRegisterInterval) {
        this.serviceRegisterInterval = serviceRegisterInterval;
    }

    public void setEnableKeepAlive(boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setPermitKeepAliveTime(Duration permitKeepAliveTime) {
        this.permitKeepAliveTime = permitKeepAliveTime;
    }

    public void setPermitKeepAliveWithoutCalls(boolean permitKeepAliveWithoutCalls) {
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
    }

    public void setMaxConnectionIdle(Duration maxConnectionIdle) {
        this.maxConnectionIdle = maxConnectionIdle;
    }

    public void setMaxConnectionAge(Duration maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge;
    }

    public void setMaxConnectionAgeGrace(Duration maxConnectionAgeGrace) {
        this.maxConnectionAgeGrace = maxConnectionAgeGrace;
    }

    public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
        this.maxInboundMetadataSize = maxInboundMetadataSize;
    }

    public void setHealthServiceEnabled(boolean healthServiceEnabled) {
        this.healthServiceEnabled = healthServiceEnabled;
    }

    public void setReflectionServiceEnabled(boolean reflectionServiceEnabled) {
        this.reflectionServiceEnabled = reflectionServiceEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcPlusProperties)) {
            return false;
        }
        GrpcPlusProperties other = (GrpcPlusProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$serviceUri = this.getServiceUri();
        String other$serviceUri = other.getServiceUri();
        if (this$serviceUri == null ? other$serviceUri != null : !this$serviceUri.equals(other$serviceUri)) {
            return false;
        }
        Integer this$masterThreadNum = this.getMasterThreadNum();
        Integer other$masterThreadNum = other.getMasterThreadNum();
        if (this$masterThreadNum == null ? other$masterThreadNum != null : !((Object)this$masterThreadNum).equals(other$masterThreadNum)) {
            return false;
        }
        Integer this$workerThreadNum = this.getWorkerThreadNum();
        Integer other$workerThreadNum = other.getWorkerThreadNum();
        if (this$workerThreadNum == null ? other$workerThreadNum != null : !((Object)this$workerThreadNum).equals(other$workerThreadNum)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Integer this$serviceRegisterThreadNum = this.getServiceRegisterThreadNum();
        Integer other$serviceRegisterThreadNum = other.getServiceRegisterThreadNum();
        if (this$serviceRegisterThreadNum == null ? other$serviceRegisterThreadNum != null : !((Object)this$serviceRegisterThreadNum).equals(other$serviceRegisterThreadNum)) {
            return false;
        }
        Duration this$serviceRegisterInterval = this.getServiceRegisterInterval();
        Duration other$serviceRegisterInterval = other.getServiceRegisterInterval();
        if (this$serviceRegisterInterval == null ? other$serviceRegisterInterval != null : !((Object)this$serviceRegisterInterval).equals(other$serviceRegisterInterval)) {
            return false;
        }
        if (this.isEnableKeepAlive() != other.isEnableKeepAlive()) {
            return false;
        }
        Duration this$keepAliveTime = this.getKeepAliveTime();
        Duration other$keepAliveTime = other.getKeepAliveTime();
        if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
            return false;
        }
        Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
        Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
        if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
            return false;
        }
        Duration this$permitKeepAliveTime = this.getPermitKeepAliveTime();
        Duration other$permitKeepAliveTime = other.getPermitKeepAliveTime();
        if (this$permitKeepAliveTime == null ? other$permitKeepAliveTime != null : !((Object)this$permitKeepAliveTime).equals(other$permitKeepAliveTime)) {
            return false;
        }
        if (this.isPermitKeepAliveWithoutCalls() != other.isPermitKeepAliveWithoutCalls()) {
            return false;
        }
        Duration this$maxConnectionIdle = this.getMaxConnectionIdle();
        Duration other$maxConnectionIdle = other.getMaxConnectionIdle();
        if (this$maxConnectionIdle == null ? other$maxConnectionIdle != null : !((Object)this$maxConnectionIdle).equals(other$maxConnectionIdle)) {
            return false;
        }
        Duration this$maxConnectionAge = this.getMaxConnectionAge();
        Duration other$maxConnectionAge = other.getMaxConnectionAge();
        if (this$maxConnectionAge == null ? other$maxConnectionAge != null : !((Object)this$maxConnectionAge).equals(other$maxConnectionAge)) {
            return false;
        }
        Duration this$maxConnectionAgeGrace = this.getMaxConnectionAgeGrace();
        Duration other$maxConnectionAgeGrace = other.getMaxConnectionAgeGrace();
        if (this$maxConnectionAgeGrace == null ? other$maxConnectionAgeGrace != null : !((Object)this$maxConnectionAgeGrace).equals(other$maxConnectionAgeGrace)) {
            return false;
        }
        DataSize this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        DataSize other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !this$maxInboundMessageSize.equals(other$maxInboundMessageSize)) {
            return false;
        }
        DataSize this$maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        DataSize other$maxInboundMetadataSize = other.getMaxInboundMetadataSize();
        if (this$maxInboundMetadataSize == null ? other$maxInboundMetadataSize != null : !this$maxInboundMetadataSize.equals(other$maxInboundMetadataSize)) {
            return false;
        }
        if (this.isHealthServiceEnabled() != other.isHealthServiceEnabled()) {
            return false;
        }
        return this.isReflectionServiceEnabled() == other.isReflectionServiceEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcPlusProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $serviceUri = this.getServiceUri();
        result = result * 59 + ($serviceUri == null ? 43 : $serviceUri.hashCode());
        Integer $masterThreadNum = this.getMasterThreadNum();
        result = result * 59 + ($masterThreadNum == null ? 43 : ((Object)$masterThreadNum).hashCode());
        Integer $workerThreadNum = this.getWorkerThreadNum();
        result = result * 59 + ($workerThreadNum == null ? 43 : ((Object)$workerThreadNum).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Integer $serviceRegisterThreadNum = this.getServiceRegisterThreadNum();
        result = result * 59 + ($serviceRegisterThreadNum == null ? 43 : ((Object)$serviceRegisterThreadNum).hashCode());
        Duration $serviceRegisterInterval = this.getServiceRegisterInterval();
        result = result * 59 + ($serviceRegisterInterval == null ? 43 : ((Object)$serviceRegisterInterval).hashCode());
        result = result * 59 + (this.isEnableKeepAlive() ? 79 : 97);
        Duration $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
        Duration $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
        Duration $permitKeepAliveTime = this.getPermitKeepAliveTime();
        result = result * 59 + ($permitKeepAliveTime == null ? 43 : ((Object)$permitKeepAliveTime).hashCode());
        result = result * 59 + (this.isPermitKeepAliveWithoutCalls() ? 79 : 97);
        Duration $maxConnectionIdle = this.getMaxConnectionIdle();
        result = result * 59 + ($maxConnectionIdle == null ? 43 : ((Object)$maxConnectionIdle).hashCode());
        Duration $maxConnectionAge = this.getMaxConnectionAge();
        result = result * 59 + ($maxConnectionAge == null ? 43 : ((Object)$maxConnectionAge).hashCode());
        Duration $maxConnectionAgeGrace = this.getMaxConnectionAgeGrace();
        result = result * 59 + ($maxConnectionAgeGrace == null ? 43 : ((Object)$maxConnectionAgeGrace).hashCode());
        DataSize $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : $maxInboundMessageSize.hashCode());
        DataSize $maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        result = result * 59 + ($maxInboundMetadataSize == null ? 43 : $maxInboundMetadataSize.hashCode());
        result = result * 59 + (this.isHealthServiceEnabled() ? 79 : 97);
        result = result * 59 + (this.isReflectionServiceEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GrpcPlusProperties(enabled=" + this.isEnabled() + ", port=" + this.getPort() + ", serviceUri=" + this.getServiceUri() + ", masterThreadNum=" + this.getMasterThreadNum() + ", workerThreadNum=" + this.getWorkerThreadNum() + ", address=" + this.getAddress() + ", serviceRegisterThreadNum=" + this.getServiceRegisterThreadNum() + ", serviceRegisterInterval=" + this.getServiceRegisterInterval() + ", enableKeepAlive=" + this.isEnableKeepAlive() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", permitKeepAliveTime=" + this.getPermitKeepAliveTime() + ", permitKeepAliveWithoutCalls=" + this.isPermitKeepAliveWithoutCalls() + ", maxConnectionIdle=" + this.getMaxConnectionIdle() + ", maxConnectionAge=" + this.getMaxConnectionAge() + ", maxConnectionAgeGrace=" + this.getMaxConnectionAgeGrace() + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", maxInboundMetadataSize=" + this.getMaxInboundMetadataSize() + ", healthServiceEnabled=" + this.isHealthServiceEnabled() + ", reflectionServiceEnabled=" + this.isReflectionServiceEnabled() + ")";
    }
}

