/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.global;

import com.google.common.collect.ImmutableList;
import io.grpc.ServerInterceptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import plus.jdk.grpc.config.GrpcPlusProperties;
import plus.jdk.grpc.global.GrpcServiceInterceptorConfigurer;

public class GlobalGrpcInterceptorRegistry {
    private final ApplicationContext applicationContext;
    private final GrpcPlusProperties grpcPlusProperties;
    private ImmutableList<ServerInterceptor> sortedServiceInterceptors;

    public GlobalGrpcInterceptorRegistry(GrpcPlusProperties properties, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.grpcPlusProperties = properties;
    }

    public ImmutableList<ServerInterceptor> getServerInterceptors() {
        if (this.sortedServiceInterceptors == null) {
            this.sortedServiceInterceptors = ImmutableList.copyOf(this.initServerInterceptors());
        }
        return this.sortedServiceInterceptors;
    }

    protected List<ServerInterceptor> initServerInterceptors() {
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        for (GrpcServiceInterceptorConfigurer configurer : this.applicationContext.getBeansOfType(GrpcServiceInterceptorConfigurer.class).values()) {
            configurer.configureServerInterceptors(interceptors);
        }
        this.sortInterceptors(interceptors);
        return interceptors;
    }

    public void sortInterceptors(List<? extends ServerInterceptor> interceptors) {
        interceptors.sort((Comparator<? extends ServerInterceptor>)AnnotationAwareOrderComparator.INSTANCE);
    }
}

