/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.global;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.unit.DataSize;
import plus.jdk.grpc.annotation.GrpcService;
import plus.jdk.grpc.common.GrpcUtils;
import plus.jdk.grpc.common.IGrpcServiceRegister;
import plus.jdk.grpc.config.GrpcPlusProperties;
import plus.jdk.grpc.global.GlobalGrpcInterceptorRegistry;
import plus.jdk.grpc.model.GrpcServiceDefinition;

public class GrpcServerFactory {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerFactory.class);
    private final ApplicationContext applicationContext;
    private final BeanFactory beanFactory;
    private final GrpcPlusProperties properties;
    private final ScheduledExecutorService scheduledExecutorService;

    public Server createServer() {
        DataSize maxInboundMetadataSize;
        NettyServerBuilder builder = this.newServerBuilder();
        if (this.properties.isEnableKeepAlive()) {
            builder.keepAliveTime(this.properties.getKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).keepAliveTimeout(this.properties.getKeepAliveTimeout().toNanos(), TimeUnit.NANOSECONDS);
        }
        builder.permitKeepAliveTime(this.properties.getPermitKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).permitKeepAliveWithoutCalls(this.properties.isPermitKeepAliveWithoutCalls());
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        for (GrpcServiceDefinition service : this.findGrpcServices()) {
            String serviceName = service.getDefinition().getServiceDescriptor().getName();
            if (!serviceNames.add(serviceName)) {
                throw new IllegalStateException("Found duplicate service implementation: " + serviceName);
            }
            log.info("Registered gRPC service: " + serviceName + ", bean: " + service.getBeanName() + ", class: " + service.getBeanClazz().getName());
            builder.addService(service.getDefinition());
        }
        DataSize maxInboundMessageSize = this.properties.getMaxInboundMessageSize();
        if (maxInboundMessageSize != null) {
            builder.maxInboundMessageSize((int)maxInboundMessageSize.toBytes());
        }
        if ((maxInboundMetadataSize = this.properties.getMaxInboundMetadataSize()) != null) {
            builder.maxInboundMetadataSize((int)maxInboundMetadataSize.toBytes());
        }
        return builder.build();
    }

    protected NettyServerBuilder newServerBuilder() {
        String address = this.properties.getAddress();
        int port = this.properties.getPort();
        if (address.startsWith("unix:")) {
            String path = GrpcUtils.extractDomainSocketAddressPath(address);
            return NettyServerBuilder.forAddress((SocketAddress)new DomainSocketAddress(path)).channelType(EpollServerDomainSocketChannel.class).bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(this.properties.getMasterThreadNum().intValue())).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(this.properties.getWorkerThreadNum().intValue()));
        }
        if ("*".equals(address)) {
            return NettyServerBuilder.forPort((int)port);
        }
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)address), port));
    }

    public GrpcServerFactory(GrpcPlusProperties properties, BeanFactory beanFactory, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.beanFactory = beanFactory;
        this.properties = properties;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(properties.getServiceRegisterThreadNum());
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.updateGrpcServiceStatus(IGrpcServiceRegister::updateNodeStatus), properties.getServiceRegisterInterval().toMillis(), properties.getServiceRegisterInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void updateGrpcServiceStatus(Consumer<IGrpcServiceRegister> consumer) {
        Map registerHashMap = this.applicationContext.getBeansOfType(IGrpcServiceRegister.class);
        for (IGrpcServiceRegister register : registerHashMap.values()) {
            consumer.accept(register);
        }
    }

    protected Collection<GrpcServiceDefinition> findGrpcServices() {
        List<String> beanNames = Arrays.asList(this.applicationContext.getBeanNamesForAnnotation(GrpcService.class));
        ArrayList definitions = Lists.newArrayListWithCapacity((int)beanNames.size());
        GlobalGrpcInterceptorRegistry globalServerInterceptorRegistry = (GlobalGrpcInterceptorRegistry)this.applicationContext.getBean(GlobalGrpcInterceptorRegistry.class);
        for (String beanName : beanNames) {
            BindableService bindableService = (BindableService)this.applicationContext.getBean(beanName, BindableService.class);
            ServerServiceDefinition serviceDefinition = bindableService.bindService();
            GrpcService grpcServiceAnnotation = (GrpcService)this.applicationContext.findAnnotationOnBean(beanName, GrpcService.class);
            if (grpcServiceAnnotation == null) continue;
            serviceDefinition = this.bindInterceptors(serviceDefinition, grpcServiceAnnotation, globalServerInterceptorRegistry);
            definitions.add(new GrpcServiceDefinition(beanName, bindableService.getClass(), serviceDefinition));
            log.info("Had found gRPC service: {}, bean: {}, class: {}", new Object[]{serviceDefinition.getServiceDescriptor().getName(), beanName, bindableService.getClass().getName()});
        }
        return definitions;
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GrpcService grpcServiceAnnotation, GlobalGrpcInterceptorRegistry globalServerInterceptorRegistry) {
        ArrayList interceptors = Lists.newArrayList();
        interceptors.addAll(globalServerInterceptorRegistry.getServerInterceptors());
        for (Class<? extends ServerInterceptor> interceptorClass : grpcServiceAnnotation.interceptors()) {
            ServerInterceptor serverInterceptor;
            if (this.applicationContext.getBeanNamesForType(interceptorClass).length > 0) {
                serverInterceptor = (ServerInterceptor)this.applicationContext.getBean(interceptorClass);
            } else {
                try {
                    serverInterceptor = interceptorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new BeanCreationException("Failed to create interceptor instance", (Throwable)e);
                }
            }
            interceptors.add(serverInterceptor);
        }
        if (grpcServiceAnnotation.sortInterceptors()) {
            globalServerInterceptorRegistry.sortInterceptors(interceptors);
        }
        return ServerInterceptors.interceptForward((ServerServiceDefinition)serviceDefinition, (List)interceptors);
    }
}

