/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.global;

import io.grpc.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import plus.jdk.grpc.common.IGrpcServiceRegister;
import plus.jdk.grpc.global.GrpcServerFactory;

public class GrpcServerLifecycle
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerLifecycle.class);
    private Server server;
    private final GrpcServerFactory grpcServerFactory;

    public GrpcServerLifecycle(GrpcServerFactory grpcServerFactory) {
        this.grpcServerFactory = grpcServerFactory;
    }

    public void start() {
        try {
            Server localServer;
            this.server = localServer = this.grpcServerFactory.createServer();
            localServer.start();
            this.grpcServerFactory.updateGrpcServiceStatus(IGrpcServiceRegister::registerServiceNode);
        }
        catch (Exception e) {
            log.error("Failed to start grpc server");
        }
    }

    public void stop() {
        this.grpcServerFactory.updateGrpcServiceStatus(IGrpcServiceRegister::deregisterServiceNode);
        this.server.shutdown();
    }

    public boolean isRunning() {
        return this.server != null && !this.server.isShutdown();
    }
}

