/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.grpc.model;

import io.grpc.EquivalentAddressGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;

public class GrpcNameResolverModel {
    private String scheme = "grpc";
    private String serviceName;
    private List<String> hosts;

    public List<EquivalentAddressGroup> toEquivalentAddressGroups() {
        ArrayList<EquivalentAddressGroup> addressGroupList = new ArrayList<EquivalentAddressGroup>();
        for (String host : this.getHosts()) {
            String[] tempArr = host.split(":");
            if (tempArr.length != 2 || !tempArr[1].matches("[0-9]+")) continue;
            int port = Integer.parseInt(tempArr[1]);
            String hostAddress = tempArr[0];
            addressGroupList.add(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(hostAddress, port)));
        }
        return addressGroupList;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcNameResolverModel)) {
            return false;
        }
        GrpcNameResolverModel other = (GrpcNameResolverModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        return !(this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcNameResolverModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        return result;
    }

    public String toString() {
        return "GrpcNameResolverModel(scheme=" + this.getScheme() + ", serviceName=" + this.getServiceName() + ", hosts=" + this.getHosts() + ")";
    }
}

