/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.adapter.camunda.outbox.rest.service;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.adapter.camunda.OutboxRestConfiguration;
import pro.taskana.adapter.camunda.outbox.rest.exception.CamundaTaskEventNotFoundException;
import pro.taskana.adapter.camunda.outbox.rest.exception.InvalidArgumentException;
import pro.taskana.adapter.camunda.outbox.rest.model.CamundaTaskEvent;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class CamundaTaskEventsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaTaskEventsService.class);
    private static final String CREATE = "create";
    private static final String COMPLETE = "complete";
    private static final String DELETE = "delete";
    private static final String RETRIES = "retries";
    private static final String TYPE = "type";
    private static final List<String> ALLOWED_PARAMS = Stream.of("type", "retries").collect(Collectors.toList());
    private static final String OUTBOX_SCHEMA = OutboxRestConfiguration.getOutboxSchema();
    private static final String SQL_GET_CREATE_EVENTS = "select * from %s.event_store where type = ? and remaining_retries>0 and blocked_until < ? fetch first %d rows only";
    private static final String SQL_GET_ALL_EVENTS = "select * from %s.event_store";
    private static final String SQL_GET_EVENT = "select * from %s.event_store where id = ? ";
    private static final String SQL_GET_COMPLETE_AND_DELETE_EVENTS = "select * from %s.event_store where type = ? OR type = ? fetch first %d rows only";
    private static final String SQL_GET_EVENTS_FILTERED_BY_RETRIES = "select * from %s.event_store where remaining_retries = ?";
    private static final String SQL_GET_EVENTS_COUNT = "select count(id) from %s.event_store where remaining_retries = ?";
    private static final String SQL_WITHOUT_PLACEHOLDERS_DELETE_EVENTS = "delete from %s.event_store where id in (%s)";
    private static final String SQL_DECREASE_REMAINING_RETRIES = "update %s.event_store set remaining_retries = remaining_retries-1, blocked_until = ?, error = ? where id = ?";
    private static final String SQL_SET_REMAINING_RETRIES = "update %s.event_store set remaining_retries = ? where id = ?";
    private static final String SQL_SET_REMAINING_RETRIES_FOR_MULTIPLE_EVENTS = "update %s.event_store set remaining_retries = ? where remaining_retries = ?";
    private static final String SQL_DELETE_FAILED_EVENT = "delete from %s.event_store where id = ? and remaining_retries <=0";
    private static final String SQL_DELETE_ALL_FAILED_EVENTS = "delete from %s.event_store where remaining_retries <= 0 ";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static int maxNumberOfEventsReturned = 0;
    private DataSource dataSource = null;

    public List<CamundaTaskEvent> getEvents(MultivaluedMap<String, String> filterParams) throws InvalidArgumentException {
        List camundaTaskEvents;
        this.verifyNoInvalidParameters(filterParams);
        if (filterParams.containsKey((Object)"type") && ((List)filterParams.get((Object)"type")).contains("create")) {
            camundaTaskEvents = this.getCreateEvents();
        } else if (filterParams.containsKey((Object)"type") && ((List)filterParams.get((Object)"type")).contains("delete") && ((List)filterParams.get((Object)"type")).contains("complete")) {
            camundaTaskEvents = this.getCompleteAndDeleteEvents();
        } else if (filterParams.containsKey((Object)"retries") && filterParams.get((Object)"retries") != null) {
            int remainingRetries = this.getRetries((List)filterParams.get((Object)"retries"));
            camundaTaskEvents = this.getEventsFilteredByRetries(Integer.valueOf(remainingRetries));
        } else {
            camundaTaskEvents = this.getAllEvents();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("outbox retrieved {} camundaTaskEvents: {}", (Object)camundaTaskEvents.size(), (Object)camundaTaskEvents.stream().map(Object::toString).collect(Collectors.joining(";\n")));
        }
        return camundaTaskEvents;
    }

    public void deleteEvents(String idsAsJsonArray) {
        List idsAsIntegers = this.getIdsAsIntegers(idsAsJsonArray);
        String deleteEventsSqlWithPlaceholders = String.format("delete from %s.event_store where id in (%s)", OUTBOX_SCHEMA, this.preparePlaceHolders(idsAsIntegers.size()));
        try (Connection connection = this.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(deleteEventsSqlWithPlaceholders);
            this.setPreparedStatementValues(preparedStatement, idsAsIntegers);
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to delete events from the outbox table", (Throwable)e);
        }
    }

    public void decreaseRemainingRetriesAndLogError(String eventIdAndErrorLog) {
        String sql = String.format("update %s.event_store set remaining_retries = remaining_retries-1, blocked_until = ?, error = ? where id = ?", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            JsonNode id = OBJECT_MAPPER.readTree(eventIdAndErrorLog).get("taskEventId");
            JsonNode errorLog = OBJECT_MAPPER.readTree(eventIdAndErrorLog).get("errorLog");
            Instant blockedUntil = this.getBlockedUntil();
            preparedStatement.setTimestamp(1, Timestamp.from(blockedUntil));
            preparedStatement.setString(2, errorLog.asText());
            preparedStatement.setInt(3, id.asInt());
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to decrease the remaining retries of camunda task event", (Throwable)e);
        }
    }

    public List<CamundaTaskEvent> getEventsFilteredByRetries(Integer remainingRetries) {
        List<Object> camundaTaskEventsFilteredByRetries = new ArrayList<CamundaTaskEvent>();
        String getEventsFilteredByRetriesSql = String.format("select * from %s.event_store where remaining_retries = ?", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(getEventsFilteredByRetriesSql);){
            preparedStatement.setInt(1, remainingRetries);
            ResultSet camundaTaskEventFilteredByRetriesResultSet = preparedStatement.executeQuery();
            camundaTaskEventsFilteredByRetries = this.getCamundaTaskEvents(camundaTaskEventFilteredByRetriesResultSet);
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to retrieve failed events from the outbox", (Throwable)e);
        }
        return camundaTaskEventsFilteredByRetries;
    }

    public String getEventsCount(int remainingRetries) {
        String eventsCount = "{\"eventsCount\":0}";
        String getEventsCountSql = String.format("select count(id) from %s.event_store where remaining_retries = ?", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(getEventsCountSql);){
            preparedStatement.setInt(1, remainingRetries);
            ResultSet camundaTaskEventResultSet = preparedStatement.executeQuery();
            if (camundaTaskEventResultSet.next()) {
                eventsCount = eventsCount.replace("0", String.valueOf(camundaTaskEventResultSet.getInt(1)));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to retrieve events count from the outbox", (Throwable)e);
        }
        return eventsCount;
    }

    public CamundaTaskEvent setRemainingRetries(int id, int retriesToSet) throws CamundaTaskEventNotFoundException {
        CamundaTaskEvent event = this.getEvent(id);
        event.setRemainingRetries(retriesToSet);
        String setRemainingRetriesSql = String.format("update %s.event_store set remaining_retries = ? where id = ?", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(setRemainingRetriesSql);){
            preparedStatement.setInt(1, retriesToSet);
            preparedStatement.setInt(2, id);
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to set remaining retries for camunda task event", (Throwable)e);
        }
        return event;
    }

    public List<CamundaTaskEvent> setRemainingRetriesForMultipleEvents(int retries, int retriesToSet) {
        List camundaTaskEventsFilteredByRetries = this.getEventsFilteredByRetries(Integer.valueOf(retries));
        camundaTaskEventsFilteredByRetries.forEach(camundaTaskEvent -> camundaTaskEvent.setRemainingRetries(retriesToSet));
        String setRemainingRetriesForAllFilteredByRetriesSql = String.format("update %s.event_store set remaining_retries = ? where remaining_retries = ?", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(setRemainingRetriesForAllFilteredByRetriesSql);){
            preparedStatement.setInt(1, retriesToSet);
            preparedStatement.setInt(2, retries);
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to set remaining retries for all filtered by retries camunda task events", (Throwable)e);
        }
        return camundaTaskEventsFilteredByRetries;
    }

    public void deleteFailedEvent(int id) {
        String deleteFailedEventSql = String.format("delete from %s.event_store where id = ? and remaining_retries <=0", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(deleteFailedEventSql);){
            preparedStatement.setInt(1, id);
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to delete failed camunda task event", (Throwable)e);
        }
    }

    public void deleteAllFailedEvents() {
        String flagEventsSqlWithPlaceholders = String.format("delete from %s.event_store where remaining_retries <= 0 ", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(flagEventsSqlWithPlaceholders);){
            preparedStatement.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to delete all failed camunda task events", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CamundaTaskEvent getEvent(int id) throws CamundaTaskEventNotFoundException {
        String sql = String.format("select * from %s.event_store where id = ? ", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setInt(1, id);
            ResultSet completeAndDeleteEventsResultSet = preparedStatement.executeQuery();
            if (!completeAndDeleteEventsResultSet.next()) throw new CamundaTaskEventNotFoundException("camunda task event not found");
            CamundaTaskEvent camundaTaskEvent = new CamundaTaskEvent();
            camundaTaskEvent.setId(completeAndDeleteEventsResultSet.getInt(1));
            camundaTaskEvent.setType(completeAndDeleteEventsResultSet.getString(2));
            camundaTaskEvent.setCreated(this.formatDate((Date)completeAndDeleteEventsResultSet.getTimestamp(3)));
            camundaTaskEvent.setPayload(completeAndDeleteEventsResultSet.getString(4));
            camundaTaskEvent.setRemainingRetries(completeAndDeleteEventsResultSet.getInt(5));
            camundaTaskEvent.setBlockedUntil(completeAndDeleteEventsResultSet.getString(6));
            camundaTaskEvent.setError(completeAndDeleteEventsResultSet.getString(7));
            camundaTaskEvent.setCamundaTaskId(completeAndDeleteEventsResultSet.getString(8));
            CamundaTaskEvent camundaTaskEvent2 = camundaTaskEvent;
            return camundaTaskEvent2;
        }
        catch (SQLException e) {
            LOGGER.error("Caughr exception while trying to retrieve camunda task event", (Throwable)e);
        }
        throw new CamundaTaskEventNotFoundException("camunda task event not found");
    }

    public List<CamundaTaskEvent> getAllEvents() {
        List<Object> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        String sql = String.format("select * from %s.event_store", OUTBOX_SCHEMA);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            ResultSet camundaTaskEventResultSet = preparedStatement.executeQuery();
            camundaTaskEvents = this.getCamundaTaskEvents(camundaTaskEventResultSet);
        }
        catch (Exception e) {
            LOGGER.warn("Caught Exception while trying to retrieve all events from the outbox", (Throwable)e);
        }
        return camundaTaskEvents;
    }

    private int getRetries(List<String> retries) throws InvalidArgumentException {
        try {
            return Integer.parseInt(retries.get(0));
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("retries param must be of type Integer!");
        }
    }

    private void verifyNoInvalidParameters(MultivaluedMap<String, String> filterParams) throws InvalidArgumentException {
        List invalidParams = filterParams.keySet().stream().filter(key -> !ALLOWED_PARAMS.contains(key)).collect(Collectors.toList());
        if (!invalidParams.isEmpty()) {
            throw new InvalidArgumentException("Provided invalid request params: " + invalidParams);
        }
    }

    private Instant getBlockedUntil() {
        Duration blockedDuration = OutboxRestConfiguration.getDurationBetweenTaskCreationRetries();
        return Instant.now().plus(blockedDuration);
    }

    private static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    private List<CamundaTaskEvent> getCreateEvents() {
        List<Object> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        try (Connection connection = this.getConnection();){
            String sql = String.format("select * from %s.event_store where type = ? and remaining_retries>0 and blocked_until < ? fetch first %d rows only", OUTBOX_SCHEMA, maxNumberOfEventsReturned);
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.setString(1, "create");
                preparedStatement.setTimestamp(2, Timestamp.from(Instant.now()));
                ResultSet camundaTaskEventResultSet = preparedStatement.executeQuery();
                camundaTaskEvents = this.getCamundaTaskEvents(camundaTaskEventResultSet);
            }
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught Exception while trying to retrieve create events from the outbox", (Throwable)e);
        }
        return camundaTaskEvents;
    }

    private String preparePlaceHolders(int length) {
        return String.join((CharSequence)",", Collections.nCopies(length, "?"));
    }

    private void setPreparedStatementValues(PreparedStatement preparedStatement, List<Integer> ids) throws SQLException {
        for (int i = 0; i < ids.size(); ++i) {
            preparedStatement.setObject(i + 1, ids.get(i));
        }
    }

    private List<CamundaTaskEvent> getCamundaTaskEvents(ResultSet createEventsResultSet) throws SQLException {
        ArrayList<CamundaTaskEvent> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        while (createEventsResultSet.next()) {
            CamundaTaskEvent camundaTaskEvent = new CamundaTaskEvent();
            camundaTaskEvent.setId(createEventsResultSet.getInt(1));
            camundaTaskEvent.setType(createEventsResultSet.getString(2));
            camundaTaskEvent.setCreated(this.formatDate((Date)createEventsResultSet.getTimestamp(3)));
            camundaTaskEvent.setPayload(createEventsResultSet.getString(4));
            camundaTaskEvent.setRemainingRetries(createEventsResultSet.getInt(5));
            camundaTaskEvent.setBlockedUntil(createEventsResultSet.getString(6));
            camundaTaskEvent.setError(createEventsResultSet.getString(7));
            camundaTaskEvent.setCamundaTaskId(createEventsResultSet.getString(8));
            camundaTaskEvents.add(camundaTaskEvent);
        }
        return camundaTaskEvents;
    }

    private List<Integer> getIdsAsIntegers(String idsAsJsonArray) {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<Integer> idsAsIntegers = new ArrayList<Integer>();
        try {
            JsonNode idsAsJsonArrayNode = objectMapper.readTree(idsAsJsonArray).get("taskCreationIds");
            if (idsAsJsonArrayNode != null) {
                idsAsJsonArrayNode.forEach(id -> idsAsIntegers.add(id.asInt()));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Caught IOException while trying to read the passed JSON-Object in the POST-Request to delete events from the outbox table", (Throwable)e);
        }
        return idsAsIntegers;
    }

    private List<CamundaTaskEvent> getCompleteAndDeleteEvents() {
        List<Object> camundaTaskEvents = new ArrayList<CamundaTaskEvent>();
        String sql = String.format("select * from %s.event_store where type = ? OR type = ? fetch first %d rows only", OUTBOX_SCHEMA, maxNumberOfEventsReturned);
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, "complete");
            preparedStatement.setString(2, "delete");
            ResultSet completeAndDeleteEventsResultSet = preparedStatement.executeQuery();
            camundaTaskEvents = this.getCamundaTaskEvents(completeAndDeleteEventsResultSet);
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught exception while trying to retrieve complete/delete events from the outbox", (Throwable)e);
        }
        return camundaTaskEvents;
    }

    private Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
        }
        catch (NullPointerException | SQLException e) {
            LOGGER.warn("Caught {} while trying to retrieve a connection from the provided datasource", (Object)e.getClass().getName());
        }
        if (connection == null) {
            LOGGER.warn("Retrieved connection was NULL, Please make sure to provide a valid datasource.");
            throw new RuntimeException("Retrieved connection was NULL. Please make sure to provide a valid datasource.");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() {
        Class<CamundaTaskEventsService> clazz = CamundaTaskEventsService.class;
        synchronized (CamundaTaskEventsService.class) {
            if (this.dataSource == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.getDataSourceFromPropertiesFile();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dataSource;
        }
    }

    private DataSource getDataSourceFromPropertiesFile() {
        try {
            String jndiUrl = OutboxRestConfiguration.getOutboxDatasourceJndi();
            this.dataSource = jndiUrl != null ? (DataSource)new InitialContext().lookup(jndiUrl) : CamundaTaskEventsService.createDatasource((String)OutboxRestConfiguration.getOutboxDatasourceDriver(), (String)OutboxRestConfiguration.getOutboxDatasourceUrl(), (String)OutboxRestConfiguration.getOutboxDatasourceUsername(), (String)OutboxRestConfiguration.getOutboxDatasourcePassword());
        }
        catch (NullPointerException | NamingException e) {
            LOGGER.warn("Caught {} while trying to retrieve the datasource from the provided properties file", (Object)e.getClass().getName());
        }
        return this.dataSource;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault()).format(date.toInstant());
    }

    static {
        if (maxNumberOfEventsReturned == 0) {
            maxNumberOfEventsReturned = OutboxRestConfiguration.getOutboxMaxNumberOfEvents();
        }
        LOGGER.info("Outbox Rest Api will return at max {} events per request", (Object)maxNumberOfEventsReturned);
    }
}

