-- this script updates the TASKANA database schema from version 4.11.0 to version 5.0.0.

SET search_path = %schemaName%;

INSERT INTO TASKANA_SCHEMA_VERSION (VERSION, CREATED) VALUES ('5.0.0', CURRENT_TIMESTAMP);

ALTER TABLE OBJECT_REFERENCE ADD COLUMN TASK_ID VARCHAR(40) NOT NULL DEFAULT 'EMPTY';

DROP INDEX IF EXISTS IDX_CLASSIFICATION_1;
CREATE INDEX IDX_CLASSIFICATION_ID ON CLASSIFICATION
   (ID ASC, CUSTOM_8, CUSTOM_7, CUSTOM_6, CUSTOM_5, CUSTOM_4,
   CUSTOM_3, CUSTOM_2, CUSTOM_1, APPLICATION_ENTRY_POINT,
   SERVICE_LEVEL, PRIORITY, DESCRIPTION, NAME, MODIFIED,
   CREATED, VALID_IN_DOMAIN, DOMAIN, TYPE, CATEGORY, PARENT_KEY,
   PARENT_ID, KEY);
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_CLASSIFICATION_2;
CREATE INDEX IDX_CLASSIFICATION_CATEGORY ON CLASSIFICATION
   (CATEGORY ASC, DOMAIN ASC, TYPE ASC, CUSTOM_1
   ASC, CUSTOM_8 ASC, CUSTOM_7 ASC, CUSTOM_6 ASC,
   CUSTOM_5 ASC, CUSTOM_4 ASC, CUSTOM_3 ASC, CUSTOM_2
   ASC, APPLICATION_ENTRY_POINT ASC, SERVICE_LEVEL
   ASC, PRIORITY ASC, DESCRIPTION ASC, NAME ASC,
   CREATED ASC, VALID_IN_DOMAIN ASC, PARENT_KEY ASC, PARENT_ID
   ASC, KEY ASC, ID ASC);
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_CLASSIFICATION_3;
CREATE INDEX IDX_CLASSIFICATION_KEY_DOMAIN ON CLASSIFICATION
  (KEY ASC, DOMAIN ASC, CUSTOM_8, CUSTOM_7, CUSTOM_6,
   CUSTOM_5, CUSTOM_4, CUSTOM_3, CUSTOM_2, CUSTOM_1,
   APPLICATION_ENTRY_POINT, SERVICE_LEVEL, PRIORITY,
   DESCRIPTION, NAME, CREATED, VALID_IN_DOMAIN,
   TYPE, CATEGORY, PARENT_KEY, PARENT_ID, ID) ;
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_TASK_1;
CREATE INDEX IDX_TASK_WORKBASKET_KEY_DOMAIN ON TASK
   (WORKBASKET_KEY ASC, DOMAIN DESC);
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_TASK_2;
CREATE INDEX IDX_TASK_POR_VALUE ON TASK
   (LOWER(POR_VALUE) ASC, WORKBASKET_ID ASC);
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_ATTACHMENT_1;
DROP INDEX IF EXISTS IDX_ATTACHMENT_2;
CREATE INDEX IDX_ATTACHMENT_TASK_ID ON ATTACHMENT
   (TASK_ID ASC, RECEIVED ASC, CLASSIFICATION_ID
   ASC, CLASSIFICATION_KEY ASC, MODIFIED ASC, CREATED
   ASC, ID ASC) ;
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_WORKBASKET_1;
CREATE INDEX IDX_WORKBASKET_ID ON WORKBASKET
   (ID ASC, ORG_LEVEL_4, ORG_LEVEL_3, ORG_LEVEL_2,
   ORG_LEVEL_1, OWNER, DESCRIPTION, TYPE, DOMAIN, NAME, KEY);
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_WORKBASKET_2;
CREATE INDEX IDX_WORKBASKET_KEY_DOMAIN ON WORKBASKET
   (KEY ASC, DOMAIN ASC, ORG_LEVEL_4,
   ORG_LEVEL_3, ORG_LEVEL_2, ORG_LEVEL_1, CUSTOM_4,
   CUSTOM_3, CUSTOM_2, CUSTOM_1, OWNER, DESCRIPTION,
   TYPE, NAME, MODIFIED, CREATED, ID) ;
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_WORKBASKET_3;
CREATE INDEX IDX_WORKBASKET_KEY_DOMAIN_ID ON WORKBASKET
   (KEY ASC, DOMAIN ASC, ID) ;
   COMMIT WORK ;

DROP INDEX IF EXISTS IDX_WBAL_1;
CREATE INDEX IDX_WORKBASKET_ACCESS_LIST_ACCESS_ID ON WORKBASKET_ACCESS_LIST
   (ACCESS_ID ASC, WORKBASKET_ID ASC, PERM_READ ASC) ;
COMMIT WORK ;

DROP INDEX IF EXISTS IDX_WBAL_2;
CREATE INDEX IDX_WORKBASKET_ACCESS_LIST_WORKBASKET_ID ON WORKBASKET_ACCESS_LIST
   (WORKBASKET_ID ASC, PERM_CUSTOM_12 ASC, PERM_CUSTOM_11
   ASC, PERM_CUSTOM_10 ASC, PERM_CUSTOM_9 ASC, PERM_CUSTOM_8
   ASC, PERM_CUSTOM_7 ASC, PERM_CUSTOM_6 ASC, PERM_CUSTOM_5
   ASC, PERM_CUSTOM_4 ASC, PERM_CUSTOM_3 ASC, PERM_CUSTOM_2
   ASC, PERM_CUSTOM_1 ASC, PERM_DISTRIBUTE ASC, PERM_TRANSFER
   ASC, PERM_APPEND ASC, PERM_OPEN ASC, PERM_READ
   ASC, ACCESS_ID ASC) ;
COMMIT WORK ;
