-- this script updates the TASKANA database schema from version 4.3.0 to version 4.8.0.

SET search_path = %schemaName%;

INSERT INTO TASKANA_SCHEMA_VERSION (VERSION, CREATED) VALUES ('4.8.0', CURRENT_TIMESTAMP);

ALTER TABLE TASK ADD COLUMN RECEIVED TIMESTAMP NULL;
ALTER TABLE TASK ADD COLUMN MANUAL_PRIORITY INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_1 INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_2 INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_3 INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_4 INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_5 INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_6 INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_7 INT NULL;
ALTER TABLE TASK ADD COLUMN CUSTOM_INT_8 INT NULL;

ALTER TABLE CONFIGURATION ADD COLUMN CUSTOM_ATTRIBUTES TEXT NULL;

ALTER TABLE SCHEDULED_JOB ALTER COLUMN TYPE SET DATA TYPE VARCHAR(255);

ALTER TABLE CLASSIFICATION ALTER COLUMN DOMAIN SET DATA TYPE VARCHAR(32);

ALTER TABLE TASK_HISTORY_EVENT ADD COLUMN TASK_PRIORITY INT NULL;
ALTER TABLE TASK_HISTORY_EVENT ADD COLUMN TASK_PLANNED TIMESTAMP NULL;
ALTER TABLE TASK_HISTORY_EVENT ADD COLUMN TASK_DUE TIMESTAMP NULL;
ALTER TABLE TASK_HISTORY_EVENT ADD COLUMN TASK_OWNER VARCHAR(32) NULL;
ALTER TABLE TASK_HISTORY_EVENT ADD COLUMN TASK_CLASSIFICATION_NAME VARCHAR(255) NULL;
ALTER TABLE TASK_HISTORY_EVENT ADD COLUMN ATTACHMENT_CLASSIFICATION_NAME VARCHAR(255) NULL;
ALTER TABLE TASK_HISTORY_EVENT ADD COLUMN WORKBASKET_NAME VARCHAR(255) NULL;

CREATE TABLE USER_INFO (
    USER_ID                     VARCHAR(32)     NOT NULL,
    FIRST_NAME                  VARCHAR(32)     NULL,
    LASTNAME                    VARCHAR(32)     NULL,
    FULL_NAME                   VARCHAR(64)     NULL,
    LONG_NAME                   VARCHAR(64)     NULL,
    E_MAIL                      VARCHAR(64)     NULL,
    PHONE                       VARCHAR(32)     NULL,
    MOBILE_PHONE                VARCHAR(32)     NULL,
    ORG_LEVEL_4                 VARCHAR(32)     NULL,
    ORG_LEVEL_3                 VARCHAR(32)     NULL,
    ORG_LEVEL_2                 VARCHAR(32)     NULL,
    ORG_LEVEL_1                 VARCHAR(32)     NULL,
    DATA                        TEXT            NULL,
    PRIMARY KEY (USER_ID)
);
