package pt.lightweightform.lfkotlin

import kotlin.js.JsName
import kotlin.jvm.JvmOverloads

/**
 * Validation issue.
 */
@JsName("Issue")
public data class Issue @JvmOverloads constructor(
    /**
     * Code of the issue. Must uniquely identify an issue withing the issues of a certain value.
     */
    @JsName("code")
    public val code: String,
    /**
     * Whether this issue represents a warning (`false` by default, meaning that the issue
     * represents an error).
     */
    @JsName("isWarning")
    public val isWarning: Boolean = false,
    /**
     * Additional issue data. Useful, for example, to display internationalised messages about the
     * issue.
     */
    @JsName("data")
    public val data: Any? = null
)
