@file:JvmName("LfDate")

package pt.lightweightform.lfkotlin

import kotlin.jvm.JvmName

/**
 * A common date which is represented by a JS `Date` on the JS side and as an `Instant` on the JVM.
 * Use `toEpochMilliseconds()` to use this value from common code.
 */
public expect class LfDate

/**
 * Date-range represented as an array of [LfDate].
 */
public typealias LfDateRange = Array<LfDate>

/**
 * Builds as an LF date from the number of milliseconds since the Unix/POSIX epoch.
 */
public expect fun Long.toLfDate(): LfDate

/**
 * Converts an LF date to the number of milliseconds since the Unix/POSIX epoch.
 */
public expect fun LfDate.toEpochMilliseconds(): Long
