package pt.lightweightform.lfkotlin.computedvalues

import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.Context
import pt.lightweightform.lfkotlin.Path

/**
 * Computed value with the sum of all elements of the array at [dependencyPath].
 */
public open class Sum<N : Number?>(private val dependencyPath: Path) : ComputedValue<Double> {
    override fun Context.compute(): Double {
        val dependencyValue: Array<N> = get(dependencyPath)
        var sum = 0.0
        for (el in dependencyValue) {
            sum += el?.toDouble() ?: 0.0
        }
        return sum
    }
}

/**
 * Computed value with the sum of a "column" of the array at [dependencyPath] identified by
 * [selector].
 */
public open class SumBy<E, N : Number?>(
    private val dependencyPath: Path,
    private val selector: (E) -> N
) : ComputedValue<Double> {
    override fun Context.compute(): Double {
        val dependencyValue: Array<E> = get(dependencyPath)
        var sum = 0.0
        for (el in dependencyValue) {
            sum += selector(el)?.toDouble() ?: 0.0
        }
        return sum
    }
}
