package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

/**
 * Creates a schema from an enum's value names. Maps to a schema of type "string" in LF where the
 * allowed values are the names of the enum's values.
 *
 * The [initialValue] defaults to the first enum value's name.
 */
public inline fun <reified T : Enum<T>> enumNameSchema(
    initialValue: String? = null,
    computedInitialValue: InitialValue<String>? = null,
    computedValue: ComputedValue<String>? = null,
    isClientOnly: Boolean? = null,
    validations: List<Validation<String>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<String> = stringSchema(
    if (initialValue == null && computedInitialValue == null) enumValues<T>().first().name
    else initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    enumValues<T>().map { value -> value.name },
    null,
    null,
    null,
    null,
    null,
    validations,
    initialState,
    extra
)

/**
 * Creates a nullable schema from an enum's value names. Maps to a schema of type "string" with
 * `isNullable` set to `true` in LF where the allowed values are the names of the enum's values.
 */
public inline fun <reified T : Enum<T>> nullableEnumNameSchema(
    initialValue: String? = null,
    computedInitialValue: InitialValue<String?>? = null,
    computedValue: ComputedValue<String?>? = null,
    isClientOnly: Boolean? = null,
    isRequired: Boolean? = null,
    computedIsRequired: IsRequired? = null,
    validations: List<Validation<String>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<String?> = nullableStringSchema(
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    enumValues<T>().map { value -> value.name },
    null,
    null,
    null,
    null,
    null,
    validations,
    initialState,
    extra
)
