package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

/**
 * Creates a schema from an enum's value ordinals. Maps to a schema of type "number" with
 * `isInteger` set to `true` in LF where the allowed values are the ordinals of the enum's values.
 *
 * The [initialValue] defaults to the first enum value's ordinal.
 */
public inline fun <reified T : Enum<T>> enumOrdinalSchema(
    initialValue: Int? = null,
    computedInitialValue: InitialValue<Int>? = null,
    computedValue: ComputedValue<Int>? = null,
    isClientOnly: Boolean? = null,
    validations: List<Validation<Int>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Int> = intSchema(
    if (initialValue == null && computedInitialValue == null) enumValues<T>().first().ordinal
    else initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    enumValues<T>().map { value -> value.ordinal },
    null,
    null,
    null,
    null,
    null,
    validations,
    initialState,
    extra
)

/**
 * Creates a nullable schema from an enum's value ordinals. Maps to a schema of type "number" with
 * `isInteger` set to `true`, and isNullable` set to `true` in LF where the allowed values are the
 * ordinals of the enum's values.
 */
public inline fun <reified T : Enum<T>> nullableEnumOrdinalSchema(
    initialValue: Int? = null,
    computedInitialValue: InitialValue<Int?>? = null,
    computedValue: ComputedValue<Int?>? = null,
    isClientOnly: Boolean? = null,
    isRequired: Boolean? = null,
    computedIsRequired: IsRequired? = null,
    validations: List<Validation<Int>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Int?> = nullableIntSchema(
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    enumValues<T>().map { value -> value.ordinal },
    null,
    null,
    null,
    null,
    null,
    validations,
    initialState,
    extra
)
