package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

internal expect fun floatSchemaImpl(
    isNullable: Boolean,
    representsInteger: Boolean,
    initialValue: Float?,
    computedInitialValue: InitialValue<Float?>?,
    computedValue: ComputedValue<Float?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Float>?,
    computedAllowedValues: AllowedValues<Float>?,
    min: Float?,
    computedMin: Bound<Float>?,
    max: Float?,
    computedMax: Bound<Float>?,
    validations: List<Validation<Float>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Float?>

/**
 * Creates a float schema. Maps to a schema of type "number" in LF.
 */
@Suppress("UNCHECKED_CAST")
public fun floatSchema(
    representsInteger: Boolean = false,
    initialValue: Float? = null,
    computedInitialValue: InitialValue<Float>? = null,
    computedValue: ComputedValue<Float>? = null,
    isClientOnly: Boolean? = null,
    allowedValues: List<Float>? = null,
    computedAllowedValues: AllowedValues<Float>? = null,
    min: Float? = null,
    computedMin: Bound<Float>? = null,
    max: Float? = null,
    computedMax: Bound<Float>? = null,
    validations: List<Validation<Float>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Float> = floatSchemaImpl(
    false,
    representsInteger,
    initialValue,
    computedInitialValue,
    computedValue as ComputedValue<Float?>?,
    isClientOnly,
    null,
    null,
    allowedValues,
    computedAllowedValues,
    min,
    computedMin,
    max,
    computedMax,
    validations,
    initialState,
    extra
) as Schema<Float>

/**
 * Creates a nullable float schema. Maps to a schema of type "number" with `isNullable` set to
 * `true` in LF.
 */
@Suppress("UNCHECKED_CAST")
public fun nullableFloatSchema(
    representsInteger: Boolean = false,
    initialValue: Float? = null,
    computedInitialValue: InitialValue<Float?>? = null,
    computedValue: ComputedValue<Float?>? = null,
    isClientOnly: Boolean? = null,
    isRequired: Boolean? = null,
    computedIsRequired: IsRequired? = null,
    allowedValues: List<Float>? = null,
    computedAllowedValues: AllowedValues<Float>? = null,
    min: Float? = null,
    computedMin: Bound<Float>? = null,
    max: Float? = null,
    computedMax: Bound<Float>? = null,
    validations: List<Validation<Float>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Float?> = floatSchemaImpl(
    true,
    representsInteger,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    min,
    computedMin,
    max,
    computedMax,
    validations,
    initialState,
    extra
)
