package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.LfLong
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

internal expect fun longSchemaImpl(
    isNullable: Boolean,
    initialValue: LfLong?,
    computedInitialValue: InitialValue<LfLong?>?,
    computedValue: ComputedValue<LfLong?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<LfLong>?,
    computedAllowedValues: AllowedValues<LfLong>?,
    min: LfLong?,
    computedMin: Bound<LfLong>?,
    max: LfLong?,
    computedMax: Bound<LfLong>?,
    validations: List<Validation<LfLong>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<LfLong?>

/**
 * Creates a long schema. Maps to a schema of type "number" with `isInteger` set to `true` and
 * appropriate min/max bounds in LF.
 */
@Suppress("UNCHECKED_CAST")
public fun longSchema(
    initialValue: LfLong? = null,
    computedInitialValue: InitialValue<LfLong>? = null,
    computedValue: ComputedValue<LfLong>? = null,
    isClientOnly: Boolean? = null,
    allowedValues: List<LfLong>? = null,
    computedAllowedValues: AllowedValues<LfLong>? = null,
    min: LfLong? = null,
    computedMin: Bound<LfLong>? = null,
    max: LfLong? = null,
    computedMax: Bound<LfLong>? = null,
    validations: List<Validation<LfLong>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<LfLong> = longSchemaImpl(
    false,
    initialValue,
    computedInitialValue,
    computedValue as ComputedValue<LfLong?>?,
    isClientOnly,
    null,
    null,
    allowedValues,
    computedAllowedValues,
    min,
    computedMin,
    max,
    computedMax,
    validations,
    initialState,
    extra
) as Schema<LfLong>

/**
 * Creates a nullable long schema. Maps to a schema of type "number" with `isNullable` set to
 * `true`, `isInteger` set to `true` and appropriate min/max bounds in LF.
 */
@Suppress("UNCHECKED_CAST")
public fun nullableLongSchema(
    initialValue: LfLong? = null,
    computedInitialValue: InitialValue<LfLong?>? = null,
    computedValue: ComputedValue<LfLong?>? = null,
    isClientOnly: Boolean? = null,
    isRequired: Boolean? = null,
    computedIsRequired: IsRequired? = null,
    allowedValues: List<LfLong>? = null,
    computedAllowedValues: AllowedValues<LfLong>? = null,
    min: LfLong? = null,
    computedMin: Bound<LfLong>? = null,
    max: LfLong? = null,
    computedMax: Bound<LfLong>? = null,
    validations: List<Validation<LfLong>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<LfLong?> = longSchemaImpl(
    true,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    min,
    computedMin,
    max,
    computedMax,
    validations,
    initialState,
    extra
)
