package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

internal expect fun shortSchemaImpl(
    isNullable: Boolean,
    initialValue: Short?,
    computedInitialValue: InitialValue<Short?>?,
    computedValue: ComputedValue<Short?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Short>?,
    computedAllowedValues: AllowedValues<Short>?,
    min: Short?,
    computedMin: Bound<Short>?,
    max: Short?,
    computedMax: Bound<Short>?,
    validations: List<Validation<Short>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Short?>

/**
 * Creates a short schema. Maps to a schema of type "number" with `isInteger` set to `true` and
 * appropriate min/max bounds in LF.
 */
@Suppress("UNCHECKED_CAST")
public fun shortSchema(
    initialValue: Short? = null,
    computedInitialValue: InitialValue<Short>? = null,
    computedValue: ComputedValue<Short>? = null,
    isClientOnly: Boolean? = null,
    allowedValues: List<Short>? = null,
    computedAllowedValues: AllowedValues<Short>? = null,
    min: Short? = null,
    computedMin: Bound<Short>? = null,
    max: Short? = null,
    computedMax: Bound<Short>? = null,
    validations: List<Validation<Short>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Short> = shortSchemaImpl(
    false,
    initialValue,
    computedInitialValue,
    computedValue as ComputedValue<Short?>?,
    isClientOnly,
    null,
    null,
    allowedValues,
    computedAllowedValues,
    min,
    computedMin,
    max,
    computedMax,
    validations,
    initialState,
    extra
) as Schema<Short>

/**
 * Creates a nullable short schema. Maps to a schema of type "number" with `isNullable` set to
 * `true`, `isInteger` set to `true` and appropriate min/max bounds in LF.
 */
@Suppress("UNCHECKED_CAST")
public fun nullableShortSchema(
    initialValue: Short? = null,
    computedInitialValue: InitialValue<Short?>? = null,
    computedValue: ComputedValue<Short?>? = null,
    isClientOnly: Boolean? = null,
    isRequired: Boolean? = null,
    computedIsRequired: IsRequired? = null,
    allowedValues: List<Short>? = null,
    computedAllowedValues: AllowedValues<Short>? = null,
    min: Short? = null,
    computedMin: Bound<Short>? = null,
    max: Short? = null,
    computedMax: Bound<Short>? = null,
    validations: List<Validation<Short>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Short?> = shortSchemaImpl(
    true,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    min,
    computedMin,
    max,
    computedMax,
    validations,
    initialState,
    extra
)
