package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation

internal expect fun <T : Any> tableSchemaImpl(
    rowsSchema: Schema<T>,
    isNullable: Boolean,
    initialValue: Array<T>?,
    computedInitialValue: InitialValue<Array<T>?>?,
    computedValue: ComputedValue<Array<T>?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Array<T>>?,
    computedAllowedValues: AllowedValues<Array<T>>?,
    minSize: Int?,
    computedMinSize: Bound<Int>?,
    maxSize: Int?,
    computedMaxSize: Bound<Int>?,
    validations: List<Validation<Array<T>>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Array<T>?>

/**
 * Creates a table schema. Maps to a schema of type "table" in LF.
 */
@Suppress("UNCHECKED_CAST")
public fun <T : Any> tableSchema(
    rowsSchema: Schema<T>,
    initialValue: Array<T>? = null,
    computedInitialValue: InitialValue<Array<T>>? = null,
    computedValue: ComputedValue<Array<T>>? = null,
    isClientOnly: Boolean? = null,
    allowedValues: List<Array<T>>? = null,
    computedAllowedValues: AllowedValues<Array<T>>? = null,
    minSize: Int? = null,
    computedMinSize: Bound<Int>? = null,
    maxSize: Int? = null,
    computedMaxSize: Bound<Int>? = null,
    validations: List<Validation<Array<T>>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Array<T>> = arraySchemaImpl(
    rowsSchema,
    false,
    initialValue,
    computedInitialValue,
    computedValue as ComputedValue<Array<T>?>?,
    isClientOnly,
    null,
    null,
    allowedValues,
    computedAllowedValues,
    minSize,
    computedMinSize,
    maxSize,
    computedMaxSize,
    validations,
    initialState,
    extra
) as Schema<Array<T>>

/**
 * Creates a nullable table schema. Maps to a schema of type "table" with `isNullable` set to `true`
 * in LF.
 */
public fun <T : Any> nullableTableSchema(
    rowsSchema: Schema<T>,
    initialValue: Array<T>? = null,
    computedInitialValue: InitialValue<Array<T>?>? = null,
    computedValue: ComputedValue<Array<T>?>? = null,
    isClientOnly: Boolean? = null,
    isRequired: Boolean? = null,
    computedIsRequired: IsRequired? = null,
    allowedValues: List<Array<T>>? = null,
    computedAllowedValues: AllowedValues<Array<T>>? = null,
    minSize: Int? = null,
    computedMinSize: Bound<Int>? = null,
    maxSize: Int? = null,
    computedMaxSize: Bound<Int>? = null,
    validations: List<Validation<Array<T>>>? = null,
    initialState: Map<String, Any?>? = null,
    extra: Map<String, Any?>? = null
): Schema<Array<T>?> = arraySchemaImpl(
    rowsSchema,
    true,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    minSize,
    computedMinSize,
    maxSize,
    computedMaxSize,
    validations,
    initialState,
    extra
)
