import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertFails
import pt.lightweightform.lfkotlin.LF_LONG_MAX_VALUE
import pt.lightweightform.lfkotlin.LF_LONG_MIN_VALUE
import pt.lightweightform.lfkotlin.toLfLong
import pt.lightweightform.lfkotlin.toLong

class LfLongTest {
    @Test
    fun testConversions() {
        val long = 90L
        assertEquals(long, long.toLfLong().toLong())

        val max = LF_LONG_MAX_VALUE
        val min = LF_LONG_MIN_VALUE
        assertEquals(max, max.toLfLong().toLong())
        assertEquals(min, min.toLfLong().toLong())

        val tooBig = LF_LONG_MAX_VALUE + 1
        val tooSmall = LF_LONG_MIN_VALUE - 1
        assertFails { tooBig.toLfLong() }
        assertFails { tooSmall.toLfLong() }
    }
}
