package pt.lightweightform.lfkotlin.internal

/**
 * JavaScript's `Proxy` class (needs to be polyfilled for IE support). This should work:
 * https://www.npmjs.com/package/proxy-polyfill.
 */
internal external class Proxy(target: dynamic, handler: dynamic)

/**
 * JavaScript's `Reflect` object (needs to be polyfilled for IE support).
 */
internal external val Reflect: dynamic

/**
 * Type of a [Proxy] `get` handler.
 */
internal typealias ProxyGetHandler = (target: dynamic, prop: String, receiver: dynamic) -> dynamic

/**
 * Returns a [Proxy] of [target] that proxies its `get` requests to the [getHandler].
 */
internal fun proxyGet(target: dynamic, getHandler: ProxyGetHandler): dynamic {
    val handler = js("{}")
    handler.get = getHandler
    return Proxy(target, handler)
}
