package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps
import pt.lightweightform.lfkotlin.internal.toStorageBound

internal actual fun <T> arraySchemaImpl(
    elementsSchema: Schema<T>,
    isNullable: Boolean,
    initialValue: Array<T>?,
    computedInitialValue: InitialValue<Array<T>?>?,
    computedValue: ComputedValue<Array<T>?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Array<T>>?,
    computedAllowedValues: AllowedValues<Array<T>>?,
    minSize: Int?,
    computedMinSize: Bound<Int>?,
    maxSize: Int?,
    computedMaxSize: Bound<Int>?,
    validations: List<Validation<Array<T>>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Array<T>?> {
    val schema = createSchemaWithCommonProps(
        "list",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().elementsSchema = elementsSchema
    schema.asDynamic().minSize = when {
        minSize != null -> minSize
        computedMinSize != null -> toStorageBound(computedMinSize)
        else -> undefined
    }
    schema.asDynamic().maxSize = when {
        maxSize != null -> maxSize
        computedMaxSize != null -> toStorageBound(computedMaxSize)
        else -> undefined
    }
    return schema
}
