package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps

@Suppress("UNCHECKED_CAST")
internal actual fun booleanSchemaImpl(
    isNullable: Boolean,
    initialValue: Boolean?,
    computedInitialValue: InitialValue<Boolean?>?,
    computedValue: ComputedValue<Boolean?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Boolean>?,
    computedAllowedValues: AllowedValues<Boolean>?,
    validations: List<Validation<Boolean>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Boolean?> = createSchemaWithCommonProps(
    "boolean",
    isNullable,
    initialValue,
    computedInitialValue,
    computedValue,
    isClientOnly,
    isRequired,
    computedIsRequired,
    allowedValues,
    computedAllowedValues,
    validations,
    initialState,
    extra
)
