package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps
import pt.lightweightform.lfkotlin.internal.toStorageBound

internal actual fun byteSchemaImpl(
    isNullable: Boolean,
    initialValue: Byte?,
    computedInitialValue: InitialValue<Byte?>?,
    computedValue: ComputedValue<Byte?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Byte>?,
    computedAllowedValues: AllowedValues<Byte>?,
    min: Byte?,
    computedMin: Bound<Byte>?,
    max: Byte?,
    computedMax: Bound<Byte>?,
    validations: List<Validation<Byte>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Byte?> {
    val schema = createSchemaWithCommonProps(
        "number",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().isInteger = true
    schema.asDynamic().min = when {
        min != null -> min
        computedMin != null -> toStorageBound(computedMin)
        else -> Byte.MIN_VALUE
    }
    schema.asDynamic().max = when {
        max != null -> max
        computedMax != null -> toStorageBound(computedMax)
        else -> Byte.MAX_VALUE
    }
    return schema
}
