package pt.lightweightform.lfkotlin.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KMutableProperty1
import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps

public actual external interface ClassSchema<T> : Schema<T> {
    public actual var kClass: KClass<Any>
    public actual var childInfoByName: Map<String, ChildInfo<T>>
    public actual var constructorFunction: ConstructorFunction<T>?
    public var fieldsSchemas: dynamic
}

@Suppress("UNCHECKED_CAST")
public actual fun <T : Any> classSchemaImpl(
    kClass: KClass<T>,
    childrenSchemas: Map<KMutableProperty1<T, *>, Schema<*>>,
    constructorFunction: ConstructorFunction<T>?,
    isNullable: Boolean,
    initialValue: T?,
    computedInitialValue: InitialValue<T?>?,
    computedValue: ComputedValue<T?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<T>?,
    computedAllowedValues: AllowedValues<T>?,
    validations: List<Validation<T>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): ClassSchema<T?> {
    @Suppress("UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
    val classSchema = createSchemaWithCommonProps(
        "record",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    ) as ClassSchema<T?>
    classSchema.kClass = kClass as KClass<Any>
    classSchema.constructorFunction = constructorFunction
    val childInfoByName = mutableMapOf<String, ChildInfo<T>>()
    for ((prop, schema) in childrenSchemas) {
        childInfoByName[prop.name] = ChildInfo(prop, schema)
    }
    classSchema.childInfoByName = childInfoByName as Map<String, ChildInfo<T?>>
    classSchema.fieldsSchemas = js("{}")
    for ((prop, childSchema) in childrenSchemas) {
        classSchema.fieldsSchemas[prop.name] = childSchema
    }
    return classSchema
}
