package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.LfDate
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps
import pt.lightweightform.lfkotlin.internal.toStorageBound

internal actual fun dateSchemaImpl(
    isNullable: Boolean,
    initialValue: LfDate?,
    computedInitialValue: InitialValue<LfDate?>?,
    computedValue: ComputedValue<LfDate?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<LfDate>?,
    computedAllowedValues: AllowedValues<LfDate>?,
    minDate: LfDate?,
    computedMinDate: Bound<LfDate>?,
    maxDate: LfDate?,
    computedMaxDate: Bound<LfDate>?,
    validations: List<Validation<LfDate>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<LfDate?> {
    val schema = createSchemaWithCommonProps(
        "date",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().minDate = when {
        minDate != null -> minDate
        computedMinDate != null -> toStorageBound(computedMinDate)
        else -> undefined
    }
    schema.asDynamic().maxDate = when {
        maxDate != null -> maxDate
        computedMaxDate != null -> toStorageBound(computedMaxDate)
        else -> undefined
    }
    return schema
}
