package pt.lightweightform.lfkotlin.schemas

import pt.lightweightform.lfkotlin.AllowedValues
import pt.lightweightform.lfkotlin.Bound
import pt.lightweightform.lfkotlin.ComputedValue
import pt.lightweightform.lfkotlin.InitialValue
import pt.lightweightform.lfkotlin.IsRequired
import pt.lightweightform.lfkotlin.Schema
import pt.lightweightform.lfkotlin.Validation
import pt.lightweightform.lfkotlin.internal.createSchemaWithCommonProps
import pt.lightweightform.lfkotlin.internal.toStorageBound

internal actual fun floatSchemaImpl(
    isNullable: Boolean,
    representsInteger: Boolean,
    initialValue: Float?,
    computedInitialValue: InitialValue<Float?>?,
    computedValue: ComputedValue<Float?>?,
    isClientOnly: Boolean?,
    isRequired: Boolean?,
    computedIsRequired: IsRequired?,
    allowedValues: List<Float>?,
    computedAllowedValues: AllowedValues<Float>?,
    min: Float?,
    computedMin: Bound<Float>?,
    max: Float?,
    computedMax: Bound<Float>?,
    validations: List<Validation<Float>>?,
    initialState: Map<String, Any?>?,
    extra: Map<String, Any?>?
): Schema<Float?> {
    val schema = createSchemaWithCommonProps(
        "number",
        isNullable,
        initialValue,
        computedInitialValue,
        computedValue,
        isClientOnly,
        isRequired,
        computedIsRequired,
        allowedValues,
        computedAllowedValues,
        validations,
        initialState,
        extra
    )
    schema.asDynamic().isInteger = representsInteger
    schema.asDynamic().min = when {
        min != null -> min
        computedMin != null -> toStorageBound(computedMin)
        else -> undefined
    }
    schema.asDynamic().max = when {
        max != null -> max
        computedMax != null -> toStorageBound(computedMax)
        else -> undefined
    }
    return schema
}
